/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.loadbalance;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcStatus;
import com.alibaba.dubbo.rpc.cluster.loadbalance.AbstractLoadBalance;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.monitor.MserviceStatus;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;

public class HealthLoadBalance
extends AbstractLoadBalance {
    public static final String NAME = "healthactive";
    private final SecureRandom random = new SecureRandom();
    private Integer maxThreads = Integer.parseInt(System.getProperty("JETTY_MAXTHREADS", "200"));
    private Map<String, Long> serverStartTimestamp = new ConcurrentHashMap<String, Long>(2);
    private static final Logger logger = LoggerFactory.getLogger(HealthLoadBalance.class);

    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        int length = invokers.size();
        double leastLoad = -2.0;
        int leastCount = 0;
        int[] leastIndexs = new int[length];
        int invokerMaxThread = this.maxThreads / (length + 1);
        for (int i = 0; i < length; ++i) {
            Invoker<T> invoker = invokers.get(i);
            URL invokeurl = invoker.getUrl();
            int remoteHealthLeve = ClusterHealth.getHealth((String)invokeurl.getParameter("default.instance.id"));
            RpcStatus rpcstatus = RpcStatus.getStatus(invokeurl, invocation.getMethodName());
            long startTime = this.serverStartTimestamp.computeIfAbsent(invokeurl.toIdentityString(), k -> System.currentTimeMillis());
            double activeLoad = remoteHealthLeve;
            int rpcActive = rpcstatus.getActive();
            if (rpcstatus.isHandShakeBreaked()) {
                activeLoad = 2.147483647E9;
            } else if (rpcActive > invokerMaxThread) {
                activeLoad = 2.147483646E9;
            } else if (activeLoad == -1.0) {
                if ("true".equals(System.getProperty("dubbo.loadbalance.delayinvokewhenstarted", "true"))) {
                    if (System.currentTimeMillis() - startTime < 60000L) {
                        activeLoad = 2.147483645E9;
                    } else {
                        activeLoad += (double)rpcActive;
                        rpcstatus.failedHandShake();
                    }
                    logger.info("loadbalance for initialServer,activeLoad is" + activeLoad);
                } else {
                    activeLoad += (double)rpcActive;
                }
            } else if (rpcstatus.isHandShakeBusy()) {
                activeLoad = Math.max(activeLoad, (double)MserviceStatus.Level.BUSY);
            }
            if (leastLoad == -2.0 || activeLoad < leastLoad) {
                leastLoad = activeLoad;
                leastCount = 1;
                leastIndexs[0] = i;
                continue;
            }
            if (activeLoad != leastLoad) continue;
            leastIndexs[leastCount++] = i;
        }
        Invoker<T> chooseInvoker = leastCount == 1 ? invokers.get(leastIndexs[0]) : invokers.get(leastIndexs[this.random.nextInt(leastCount)]);
        return chooseInvoker;
    }
}

