/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.dubbo;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.serialize.ObjectInput;
import com.alibaba.dubbo.common.utils.Assert;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.Codec;
import com.alibaba.dubbo.remoting.Decodeable;
import com.alibaba.dubbo.remoting.exchange.Response;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.rpc.dubbo.context.KDContextable;
import kd.bos.mservice.rpc.dubbo.context.KDInvokeContext;

public class DecodeableRpcResult
extends RpcResult
implements Codec,
Decodeable,
KDContextable {
    private static final Logger log = LoggerFactory.getLogger(DecodeableRpcResult.class);
    private static final String READ_RESPONSE_DATA_FAILED = "Read response data failed.";
    private Channel channel;
    private byte serializationType;
    private InputStream inputStream;
    private Response response;
    private Invocation invocation;
    private volatile boolean hasDecoded;
    private KDInvokeContext invokeContext;

    public DecodeableRpcResult(Channel channel, Response response, InputStream is, Invocation invocation, byte id) {
        Assert.notNull((Object)channel, (String)"channel == null");
        Assert.notNull((Object)response, (String)"response == null");
        Assert.notNull((Object)is, (String)"inputStream == null");
        this.channel = channel;
        this.response = response;
        this.inputStream = is;
        this.invocation = invocation;
        this.serializationType = id;
    }

    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object decode(Channel channel, InputStream input) throws IOException {
        ObjectInput in = CodecSupport.getSerialization(channel.getUrl(), this.serializationType).deserialize(channel.getUrl(), input);
        byte flag = in.readByte();
        switch (flag) {
            case 2: {
                try {
                    this.setInvokeContext((KDInvokeContext)in.readObject());
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new KDException(BosErrorCode.noSuchMessage, new Object[]{StringUtils.toString((String)READ_RESPONSE_DATA_FAILED, (Throwable)e)});
                }
            }
            case 3: {
                try {
                    this.setValue(in.readObject());
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new KDException(BosErrorCode.noSuchMessage, new Object[]{StringUtils.toString((String)READ_RESPONSE_DATA_FAILED, (Throwable)e)});
                }
            }
            case 4: {
                try {
                    this.setValue(in.readObject());
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new KDException(BosErrorCode.noSuchMessage, new Object[]{StringUtils.toString((String)"Read response data failed_2.", (Throwable)e)});
                }
            }
            case 1: {
                try {
                    Type[] returnType = RpcUtils.getReturnTypes((Invocation)this.invocation);
                    this.setValue(returnType == null || returnType.length == 0 ? in.readObject() : (returnType.length == 1 ? in.readObject((Class)returnType[0]) : in.readObject((Class)returnType[0], returnType[1])));
                    this.setInvokeContext((KDInvokeContext)in.readObject());
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new KDException(BosErrorCode.noSuchMessage, new Object[]{StringUtils.toString((String)READ_RESPONSE_DATA_FAILED, (Throwable)e)});
                }
            }
            case 0: {
                try {
                    Object obj = in.readObject();
                    if (!(obj instanceof Throwable)) {
                        throw new IOException("Response data error, expect Throwable, but get " + obj + ";\n Tip: the exception class thrown by the provider may not be found on this node.");
                    }
                    this.setException((Throwable)obj);
                    this.setInvokeContext((KDInvokeContext)in.readObject());
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new KDException(BosErrorCode.noSuchMessage, new Object[]{StringUtils.toString((String)READ_RESPONSE_DATA_FAILED, (Throwable)e)});
                }
            }
            default: {
                throw new IOException("Unknown result flag, expect '0' '1' '2', get " + flag);
            }
        }
        return this;
    }

    public void decode() throws Exception {
        if (!this.hasDecoded && this.channel != null && this.inputStream != null) {
            try {
                this.decode(this.channel, this.inputStream);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("Decode rpc result failed: " + e.getMessage(), e);
                }
                this.response.setStatus((byte)90);
                this.response.setErrorMessage(StringUtils.toString((Throwable)e));
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    @Override
    public KDInvokeContext getInvokeContext() {
        return this.invokeContext;
    }

    @Override
    public void setInvokeContext(KDInvokeContext invocationContext) {
        this.invokeContext = invocationContext;
    }
}

