/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.dubbo.filter;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.StaticContext;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Activate(group={"consumer"})
public class FutureFilter
implements Filter {
    protected static final Logger logger = LoggerFactory.getLogger(FutureFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        boolean isAsync = RpcUtils.isAsync((URL)invoker.getUrl(), (Invocation)invocation);
        this.fireInvokeCallback(invoker, invocation);
        Result result = invoker.invoke(invocation);
        this.syncCallback(invoker, invocation, result);
        return result;
    }

    private void syncCallback(Invoker<?> invoker, Invocation invocation, Result result) {
        if (result.hasException()) {
            this.fireThrowCallback(invoker, invocation, result.getException());
        } else {
            this.fireReturnCallback(invoker, invocation, result.getValue());
        }
    }

    private void fireInvokeCallback(Invoker<?> invoker, Invocation invocation) {
        Method onInvokeMethod = (Method)StaticContext.getSystemContext().get((Object)StaticContext.getKey((URL)invoker.getUrl(), (String)invocation.getMethodName(), (String)"oninvoke.method"));
        Object onInvokeInst = StaticContext.getSystemContext().get((Object)StaticContext.getKey((URL)invoker.getUrl(), (String)invocation.getMethodName(), (String)"oninvoke.instance"));
        if (onInvokeMethod == null && onInvokeInst == null) {
            return;
        }
        if (onInvokeMethod == null || onInvokeInst == null) {
            throw new IllegalStateException("service:" + invoker.getUrl().getServiceKey() + " has a onreturn callback config , but no such " + (onInvokeMethod == null ? "method:" : "instance") + " found. url:" + invoker.getUrl());
        }
        if (onInvokeMethod != null && !onInvokeMethod.isAccessible()) {
            onInvokeMethod.setAccessible(true);
        }
        Object[] params = invocation.getArguments();
        try {
            onInvokeMethod.invoke(onInvokeInst, params);
        }
        catch (InvocationTargetException e) {
            this.fireThrowCallback(invoker, invocation, e.getTargetException());
        }
        catch (Throwable e) {
            this.fireThrowCallback(invoker, invocation, e);
        }
    }

    private void fireReturnCallback(Invoker<?> invoker, Invocation invocation, Object result) {
        Object[] params;
        Method onReturnMethod = (Method)StaticContext.getSystemContext().get((Object)StaticContext.getKey((URL)invoker.getUrl(), (String)invocation.getMethodName(), (String)"onreturn.method"));
        Object onReturnInst = StaticContext.getSystemContext().get((Object)StaticContext.getKey((URL)invoker.getUrl(), (String)invocation.getMethodName(), (String)"onreturn.instance"));
        if (onReturnMethod == null && onReturnInst == null) {
            return;
        }
        if (onReturnMethod == null || onReturnInst == null) {
            throw new IllegalStateException("service:" + invoker.getUrl().getServiceKey() + " has a onreturn callback config , but no such " + (onReturnMethod == null ? "method" : "instance") + " found. url:" + invoker.getUrl());
        }
        if (onReturnMethod != null && !onReturnMethod.isAccessible()) {
            onReturnMethod.setAccessible(true);
        }
        Object[] args = invocation.getArguments();
        Class<?>[] rParaTypes = onReturnMethod.getParameterTypes();
        if (rParaTypes.length > 1) {
            if (rParaTypes.length == 2 && rParaTypes[1].isAssignableFrom(Object[].class)) {
                params = new Object[]{result, args};
            } else {
                params = new Object[args.length + 1];
                params[0] = result;
                System.arraycopy(args, 0, params, 1, args.length);
            }
        } else {
            params = new Object[]{result};
        }
        try {
            onReturnMethod.invoke(onReturnInst, params);
        }
        catch (InvocationTargetException e) {
            this.fireThrowCallback(invoker, invocation, e.getTargetException());
        }
        catch (Throwable e) {
            this.fireThrowCallback(invoker, invocation, e);
        }
    }

    private void fireThrowCallback(Invoker<?> invoker, Invocation invocation, Throwable exception) {
        Class<?>[] rParaTypes;
        Method onthrowMethod = (Method)StaticContext.getSystemContext().get((Object)StaticContext.getKey((URL)invoker.getUrl(), (String)invocation.getMethodName(), (String)"onthrow.method"));
        Object onthrowInst = StaticContext.getSystemContext().get((Object)StaticContext.getKey((URL)invoker.getUrl(), (String)invocation.getMethodName(), (String)"onthrow.instance"));
        if (onthrowMethod == null && onthrowInst == null) {
            return;
        }
        if (onthrowMethod == null || onthrowInst == null) {
            throw new IllegalStateException("service:" + invoker.getUrl().getServiceKey() + " has a onthrow callback config , but no such " + (onthrowMethod == null ? "method" : "instance") + " found. url:" + invoker.getUrl());
        }
        if (onthrowMethod != null && !onthrowMethod.isAccessible()) {
            onthrowMethod.setAccessible(true);
        }
        if ((rParaTypes = onthrowMethod.getParameterTypes())[0].isAssignableFrom(exception.getClass())) {
            try {
                Object[] params;
                Object[] args = invocation.getArguments();
                if (rParaTypes.length > 1) {
                    if (rParaTypes.length == 2 && rParaTypes[1].isAssignableFrom(Object[].class)) {
                        params = new Object[]{exception, args};
                    } else {
                        params = new Object[args.length + 1];
                        params[0] = exception;
                        System.arraycopy(args, 0, params, 1, args.length);
                    }
                } else {
                    params = new Object[]{exception};
                }
                onthrowMethod.invoke(onthrowInst, params);
            }
            catch (Throwable e) {
                logger.error(invocation.getMethodName() + ".call back method invoke error . callback method :" + onthrowMethod + ", url:" + invoker.getUrl(), e);
            }
        } else {
            logger.error(invocation.getMethodName() + ".call back method invoke error . callback method :" + onthrowMethod + ", url:" + invoker.getUrl(), exception);
        }
    }
}

