/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import kd.bos.mservice.rpc.dubbo.CustomSerializable;
import kd.bos.mservice.rpc.dubbo.CustomerSerializer;

public class CustomeSerializableProvider {
    private static final Logger log = Logger.getLogger(CustomeSerializableProvider.class.getName());
    private static Properties p = new Properties();
    private static Map<String, CustomSerializable> cacheSerializable;

    public static CustomSerializable getCustomSerializableClassName(String className) {
        Class<?> c;
        CustomSerializable cachedSer = cacheSerializable.get(className);
        if (cachedSer != null) {
            return cachedSer;
        }
        String customSerializableClassName = p.getProperty(className);
        try {
            c = Class.forName(className);
            if (c.isAnnotationPresent(CustomerSerializer.class)) {
                CustomerSerializer cs = c.getAnnotation(CustomerSerializer.class);
                customSerializableClassName = cs.className();
            }
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (customSerializableClassName != null) {
            try {
                c = Class.forName(customSerializableClassName);
                CustomSerializable instance = (CustomSerializable)c.newInstance();
                cacheSerializable.put(className, instance);
                return instance;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return null;
    }

    private static void init() throws IOException {
        String pstr = System.getProperty("CustomSerializableProvider.config");
        if (pstr != null) {
            p.load(new StringReader(pstr));
        }
    }

    static {
        try {
            CustomeSerializableProvider.init();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        cacheSerializable = new HashMap<String, CustomSerializable>();
    }
}

