/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo;

import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.MethodConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.MetricSystem;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.common.codec.TypeDefines;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mservice.rpc.dubbo.DubboRegistryConfigs;
import kd.bos.mservice.rpc.dubbo.DubboServiceLookup;
import kd.bos.mservice.rpc.dubbo.ExtraRegistryService;
import kd.bos.mservice.rpc.dubbo.config.KDReferenceConfig;
import kd.bos.mservice.rpc.dubbo.config.KDServiceBean;
import kd.bos.mservice.rpc.dubbo.configparser.ConfigParser;
import kd.bos.util.AppUtils;
import kd.bos.util.StringUtils;
import kd.bos.zk.ZKFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.data.Stat;

public class DubboBeanManager {
    public static final String OLD_CONFIGURATION_PATH_KEY = "mservice.config.path";
    private static final Log log = LogFactory.getLog(DubboBeanManager.class);
    private static final String CLUSTERINSTANCEID = "clusterInstanceId";
    private static final String DUBBO_PROTOCOL_THREADS = "dubbo.protocol.threads";
    private static final String DUBBO_REGISTRY_ADDRESS = "dubbo.registry.address";
    private static final String HEALTH_ACTIVE = "healthactive";
    private static ConcurrentHashMap<String, ReferenceConfig> id2referenceConfigMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ReferenceConfig> referenceConfigMap = new ConcurrentHashMap();
    private static Map<String, ReferenceConfig> referenceConfigEndpointMap = new ConcurrentHashMap<String, ReferenceConfig>();
    private static ConcurrentHashMap<String, Object> localServiceInstanceMap = new ConcurrentHashMap();
    private static Set<ServiceConfig> serviceSet = new ConcurrentHashSet();
    private static String identifyPath = "/" + System.getProperty("appName") + "_" + UUID.randomUUID().toString();
    private static String dubboIdentifyPath;
    private static CuratorFramework client;
    private static AtomicInteger reExportCount;
    private static boolean isStarted;

    public static CuratorFramework getDubboClient() {
        return client;
    }

    public static void initConfig(AbstractConfig config) {
        if (config instanceof KDServiceBean) {
            DubboBeanManager.initServiceConfig((KDServiceBean)config);
        } else if (config instanceof ReferenceConfig) {
            DubboBeanManager.initReferenceConfig((ReferenceConfig)config);
        }
    }

    public static void initReferenceConfig(ReferenceConfig config) {
        String id;
        String protocol2 = config.getProtocol();
        referenceConfigMap.put(config.getInterface() + protocol2, config);
        if (DubboBeanManager.getProtocal(null).equals(protocol2)) {
            referenceConfigMap.put(config.getInterface(), config);
        }
        if ((id = config.getId()) != null) {
            ReferenceConfig referenceConfig = id2referenceConfigMap.put(id, config);
        }
    }

    public static ReferenceConfig getReferenceConfigById(String id) {
        return id2referenceConfigMap.get(id);
    }

    public static ReferenceConfig getReferenceConfig(String interfaze) {
        ReferenceConfig config = referenceConfigMap.get(interfaze);
        if (config == null) {
            return null;
        }
        Object bean = null;
        try {
            bean = config.get();
        }
        catch (Error | Exception t) {
            log.warn("get referProxy error", t);
        }
        if (bean == null) {
            ReferenceConfig old = config;
            config = DubboBeanManager.copyReferenceConfig(config);
            DubboBeanManager.initReferenceConfig(config);
            old.destroy();
        }
        return config;
    }

    public static ReferenceConfig getReferenceConfig(String interfaze, String appId) {
        String appGroup = GrayStrategy.getAppGroup((String)appId);
        String key = interfaze + ":" + appId + ":" + appGroup;
        ReferenceConfig config = referenceConfigMap.get(key);
        if (config != null) {
            Object bean = null;
            try {
                bean = config.get();
            }
            catch (Error | Exception t) {
                log.warn("get referProxy error", t);
            }
            if (bean != null) {
                return config;
            }
        }
        if ((config = referenceConfigMap.get(interfaze)) == null) {
            return null;
        }
        ReferenceConfig copy = DubboBeanManager.copyReferenceConfig(config);
        String group = DubboBeanManager.createGroupByAppId(appId);
        copy.setGroup(group);
        copy.setAppgroup(appGroup);
        ReferenceConfig old = referenceConfigMap.putIfAbsent(key, copy);
        return old != null ? old : copy;
    }

    public static ReferenceConfig getReferenceConfigWithPrototol(String interfaze, String appId, String prototol) {
        prototol = DubboBeanManager.getProtocal(prototol);
        String appGroup = GrayStrategy.getAppGroup((String)appId);
        String key = interfaze + ":" + appId + ":" + appGroup + prototol;
        ReferenceConfig config = referenceConfigMap.get(key);
        if (config != null) {
            Object bean = null;
            try {
                bean = config.get();
            }
            catch (Error | Exception t) {
                log.warn("get referProxy error", t);
            }
            if (bean != null) {
                return config;
            }
        }
        if ((config = referenceConfigMap.get(interfaze + prototol)) == null) {
            return null;
        }
        ReferenceConfig copy = DubboBeanManager.copyReferenceConfig(config);
        copy.setProtocol(prototol);
        String group = DubboBeanManager.createGroupByAppId(appId);
        copy.setGroup(group);
        copy.setAppgroup(appGroup);
        ReferenceConfig old = referenceConfigMap.putIfAbsent(key, copy);
        return old != null ? old : copy;
    }

    public static ReferenceConfig getReferenceConfigEndpoint(String interfaze, String ip, String port) {
        ReferenceConfig originConfig = referenceConfigMap.get(interfaze);
        if (originConfig == null) {
            return null;
        }
        List instanceIds = ServiceInfoFactory.get().getServiceList().stream().filter(serviceInfo -> ip.equals(serviceInfo.getIp()) && port.equals(serviceInfo.getRpcPort())).map(ServiceInfo::getInstanceId).collect(Collectors.toList());
        String key = interfaze + "#" + ip + ":" + port + (instanceIds.isEmpty() ? "" : "#" + (String)instanceIds.get(0));
        ReferenceConfig oldHostConfig = referenceConfigEndpointMap.get(key);
        if (oldHostConfig != null) {
            Object bean = null;
            try {
                bean = oldHostConfig.get();
            }
            catch (Error | Exception t) {
                log.warn("get endpoint host [{}] referProxy error", (Object)key, (Object)t);
            }
            if (bean != null) {
                return oldHostConfig;
            }
            referenceConfigEndpointMap.remove(key).destroy();
        }
        return referenceConfigEndpointMap.computeIfAbsent(key, k -> {
            KDReferenceConfig copy = new KDReferenceConfig();
            copy.setApplication(originConfig.getApplication());
            copy.setConsumer(originConfig.getConsumer());
            copy.setRegistry(originConfig.getRegistry());
            copy.setInterface(originConfig.getInterface());
            copy.setTimeout(originConfig.getTimeout());
            copy.setGroup(DubboBeanManager.createGroupByAppId("app-endpoint"));
            copy.setUrl("dubbo://" + ip + ":" + port);
            copy.setScope("remote");
            return copy;
        });
    }

    public static void removeReferenceEndpointMap(String ip, int port, String instanceId) {
        for (String key : referenceConfigEndpointMap.keySet()) {
            String removeKey;
            if (!key.contains(removeKey = ip + ":" + port + (StringUtils.isEmpty((String)instanceId) ? "" : "#" + instanceId))) continue;
            referenceConfigEndpointMap.remove(key).destroy();
        }
    }

    private static ReferenceConfig copyReferenceConfig(ReferenceConfig config) {
        List<MethodConfig> methodConfigList;
        KDReferenceConfig copy = new KDReferenceConfig();
        copy.setApplication(config.getApplication());
        copy.setConsumer(config.getConsumer());
        copy.setRegistries(config.getRegistries());
        copy.setInterface(config.getInterface());
        copy.setTimeout(config.getTimeout());
        copy.setUrl(config.getUrl());
        copy.setScope(config.getScope());
        Integer retries = config.getRetries();
        if (retries != null) {
            copy.setRetries(retries);
        }
        if ((methodConfigList = config.getMethods()) != null) {
            copy.setMethods(methodConfigList);
        }
        return copy;
    }

    public static <T> T getLocalServiceInstance(Class<T> clazz) {
        return (T)localServiceInstanceMap.get(clazz.getName());
    }

    public static <T> T getLocalServiceInstance(Class<T> clazz, String appId) {
        return DubboBeanManager.getLocalServiceInstance(clazz.getName(), appId);
    }

    public static <T> T getLocalServiceInstance(String interfaze) {
        return (T)localServiceInstanceMap.get(interfaze);
    }

    public static <T> T getLocalServiceInstance(String interfaze, String appId) {
        String appgroup = GrayStrategy.getAppGroup((String)appId);
        return (T)localServiceInstanceMap.get(interfaze + "-" + appId + "-" + appgroup);
    }

    private static void putLocalServiceInstance(String interfaze, String appId, Object bean) {
        String appgroup = AppGroup.getRegistyAppGroup((String)appId);
        localServiceInstanceMap.put(interfaze + "-" + appId + "-" + appgroup, bean);
    }

    private static void putLocalServiceInstance(String interfaze, Object bean) {
        localServiceInstanceMap.put(interfaze, bean);
    }

    public static void unExport() {
        log.info(" unexport all service.");
        serviceSet.forEach(service -> service.unexport());
        serviceSet.clear();
    }

    public static void reExport() {
        log.warn(" lost provider,dubbo reexport " + reExportCount.addAndGet(1));
        serviceSet.forEach(service -> service.unexport());
        serviceSet.clear();
        DubboBeanManager._start();
    }

    public static void initServiceConfig(KDServiceBean config) {
        String value = System.getProperty("dubbo.protocol.port", "20880");
        if (value != null) {
            System.setProperty("SERVICE_PORT", value);
        }
        String[] appIds = config.getAppIds();
        boolean isCurrentDeployAlone = AppUtils.isDeployAloneApps((String[])appIds);
        boolean local = "local".equals(config.getScope());
        if (Instance.isAppSplit() && appIds != null || isCurrentDeployAlone) {
            HashSet<String> set = new HashSet<String>();
            for (String appId : appIds) {
                if (Instance.getDeployedCloudByApp((String)appId) != null) continue;
                DubboBeanManager.createAndInitService(appId, config, set, local);
            }
            Set clouds = Instance.getDeployedClouds();
            clouds.forEach(cloud -> {
                String cloudtag = "cloud--" + cloud;
                DubboBeanManager.createAndInitService(cloudtag, config, set, local);
            });
            String[] innerAppIds = Instance.getInnerAppIds();
            if (innerAppIds != null) {
                for (String appId : innerAppIds) {
                    set.add(appId);
                }
            }
            for (String appId : set) {
                DubboBeanManager.putLocalServiceInstance(config.getInterface(), appId, config.getRef());
            }
        } else {
            if (!local) {
                config.export();
                serviceSet.add(config);
            }
            DubboBeanManager.putLocalServiceInstance(config.getInterface(), config.getRef());
        }
        DubboBeanManager.registryExtra(config);
    }

    private static void registryExtra(KDServiceBean config) {
        ExtraRegistryService.registry(config, DubboBeanManager.createGroupByAppId(""));
    }

    private static void createAndInitService(String appId, KDServiceBean config, HashSet<String> set, boolean local) {
        KDServiceBean service = new KDServiceBean();
        service.setApplication(config.getApplication());
        service.setProvider(config.getProvider());
        service.setRegistries(config.getRegistries());
        service.setProtocol(config.getProtocol());
        service.setInterface(config.getInterface());
        service.setRef(config.getRef());
        service.setTimeout(config.getTimeout());
        if (config.getRetries() != null) {
            service.setRetries(config.getRetries());
        }
        String group = DubboBeanManager.createGroupByAppId(appId);
        service.setGroup(group);
        service.setAppgroup(AppGroup.getRegistyAppGroup((String)appId));
        if (!local) {
            service.export();
            serviceSet.add(service);
        }
        set.add(appId);
    }

    private static String createGroupByAppId(String appId) {
        return System.getProperty(CLUSTERINSTANCEID, "") + appId;
    }

    public static void start(long start) {
        isStarted = true;
        DubboBeanManager._start();
        DubboBeanManager._startDubboMonitor();
    }

    private static void initDubboIdentifyPath(Configuration global) {
        String address = DubboBeanManager.getZkUrl();
        String dubboRPath = ZKFactory.getZkRootPath((String)address);
        String split = System.getProperty("dubbo.registry.clusterSplit");
        String root = (split == null || "true".equals(split)) && Instance.getClusterName() != null ? dubboRPath + "kdubbo/" + Instance.getClusterName() : dubboRPath + "dubbo";
        dubboIdentifyPath = root + "/livingNodes";
    }

    private static void _startDubboMonitor() {
        if (!"zookeeper".equals(MserviceAssemblyConfig.MSERVICE_DISCOVERY_TYPE)) {
            return;
        }
        try {
            Timer timer = new Timer("DubboRegisterMonitor");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        Stat exists;
                        if ("true".equals(System.getProperty("dubbo.provider.reexport.enable")) && dubboIdentifyPath != null && (exists = (Stat)client.checkExists().forPath(dubboIdentifyPath + identifyPath)) == null) {
                            log.info(dubboIdentifyPath + identifyPath + " dubbo registry zookeeper has lost EPHEMERAL Node,will re export providers");
                            DubboBeanManager.reExport();
                        }
                    }
                    catch (Exception e) {
                        log.error("dubbo.registry.address:" + System.getProperty(DubboBeanManager.DUBBO_REGISTRY_ADDRESS), (Throwable)e);
                    }
                }
            }, 10000L, 3000L);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public static void _start() {
        Configuration global = ConfigurationFactory.getGlobalConfiguration();
        DubboBeanManager.initDubboIdentifyPath(global);
    }

    public static void registerConfig(String key, String text) {
        String registryType = TypeDefines.TransProtocolTypes.getTransProtocolType((String)text);
        AbstractConfig[] configs = ConfigParser.getInstance().parse(key, text);
        if (configs != null) {
            for (AbstractConfig config : configs) {
                String protocal = DubboBeanManager.getProtocal(registryType);
                DubboRegistryConfigs regConfigs = DubboRegistryConfigs.getDubboRegistryConfigs(protocal);
                if (config instanceof KDServiceBean) {
                    KDServiceBean serviceConfig = (KDServiceBean)config;
                    serviceConfig.setApplication(regConfigs.getApplicationConfig());
                    serviceConfig.setProvider(regConfigs.getProviderConfig());
                    serviceConfig.setRegistries(regConfigs.getRegistryConfigs());
                    serviceConfig.setProtocol(regConfigs.getProtocolConfig());
                    DubboBeanManager.initServiceConfig((KDServiceBean)config);
                    continue;
                }
                if (!(config instanceof ReferenceConfig)) continue;
                ReferenceConfig referenceConfig = (ReferenceConfig)config;
                referenceConfig.setApplication(regConfigs.getApplicationConfig());
                referenceConfig.setConsumer(regConfigs.getConsumerConfig());
                referenceConfig.setRegistries(regConfigs.getRegistryConfigs());
                referenceConfig.setProtocol(protocal);
                if (!DubboServiceLookup.getCanlooluplocal()) {
                    ((ReferenceConfig)config).setScope("remote");
                }
                DubboBeanManager.initReferenceConfig((ReferenceConfig)config);
            }
        }
    }

    private static String getProtocal(String registryType) {
        if ("rpc".equals(registryType)) {
            return "dubbo";
        }
        if ("http".equals(registryType)) {
            return "http";
        }
        return "dubbo";
    }

    private static String getZkUrl() {
        String address;
        if ("zookeeper".equals(MserviceAssemblyConfig.MSERVICE_DISCOVERY_TYPE)) {
            address = System.getProperty(DUBBO_REGISTRY_ADDRESS);
            if (address == null) {
                address = System.getProperty("configUrl");
            }
        } else {
            address = System.getProperty("configUrl");
        }
        if (address == null || address.trim().length() == 0) {
            throw new Error(String.format("Dubbo starting failed, %s is not configured.", DUBBO_REGISTRY_ADDRESS));
        }
        return address;
    }

    public static void endStart() {
        isStarted = false;
    }

    public static boolean isStarting() {
        return isStarted;
    }

    static {
        reExportCount = new AtomicInteger(0);
        if ("zookeeper".equals(MserviceAssemblyConfig.MSERVICE_DISCOVERY_TYPE)) {
            String url = DubboBeanManager.getZkUrl();
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(ZKFactory.getZkAddress((String)url)).retryPolicy((RetryPolicy)new RetryNTimes(3, 1000)).connectionTimeoutMs(5000).sessionTimeoutMs(60000);
            client = builder.build();
            client.start();
        }
        MetricSystem.registerGauge((String)"kd.metrics.dubbo.maxThreads", () -> Integer.getInteger(DUBBO_PROTOCOL_THREADS, 200));
        MetricSystem.registerGauge((String)"kd.metrics.zookeeper.connections", () -> ZKFactory.poolMap.size());
        isStarted = false;
    }
}

