/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.remoting.zookeeper.ZookeeperClient;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.keepalive.LivingKeeperUtils;
import kd.bos.mservice.rpc.dubbo.DubboHealthManager;
import kd.bos.redis.JedisClient;

public class MonitorThread
extends Thread {
    private boolean isStoped = false;
    private static final Log log = LogFactory.getLog(MonitorThread.class);
    private static final String LIVINGNODES = "livingNodes";

    @Override
    public void run() {
        HashSet pre = null;
        while (!this.isStoped && Boolean.parseBoolean(System.getProperty("dubbo.registry.monitor.enable", "false"))) {
            try {
                Map<String, List<String>> urlsMap = this.getRegistryUrls();
                Set<String> clusterInstances = this.getLivingInstances();
                HashSet removeurls = new HashSet(4);
                urlsMap.forEach((parentPath, urls) -> urls.forEach(url -> {
                    String instanceId = this.getInstanceId((String)url);
                    if (instanceId != null && !clusterInstances.contains(instanceId)) {
                        removeurls.add(parentPath + "/" + url);
                    }
                }));
                if (pre != null) {
                    for (String rurl : removeurls) {
                        if (!pre.contains(rurl)) continue;
                        this.deleteFromZK(rurl);
                        log.warn(String.format("delete registry url which the node not response by MserviceMonitorThread,InstanceId: %s, url:%s", this.getInstanceId(rurl), rurl));
                    }
                }
                pre = removeurls;
            }
            catch (Throwable e) {
                log.error("DubboHealthManager MonitorThread error", e);
            }
            LockSupport.parkNanos(705032704L);
        }
    }

    private void deleteFromZK(String rurl) {
        String c = URL.decode(rurl);
        if (c.contains("://")) {
            ZookeeperClient zkclient = DubboHealthManager.getZkClient();
            zkclient.delete(rurl);
        }
    }

    private String getInstanceId(String url) {
        URL childUrl;
        String instanceid;
        String c = URL.decode(url);
        if (c.contains("://") && (instanceid = (childUrl = URL.valueOf(c)).getParameter("default.instance.id")) != null) {
            return instanceid.intern();
        }
        return null;
    }

    private Set<String> getLivingInstances() {
        try (JedisClient jedis = LivingKeeperUtils.createLivingMonitorJedisClient();){
            Map instances = jedis.hgetAll(LivingKeeperUtils.clusterKey);
            HashSet<String> set = new HashSet<String>(4);
            for (Map.Entry entry : instances.entrySet()) {
                String instanceid = (String)entry.getValue();
                if (jedis.exists(instanceid).booleanValue()) {
                    set.add(instanceid.substring(LivingKeeperUtils.PRE.length()));
                    continue;
                }
                jedis.hdel(LivingKeeperUtils.clusterKey, new String[]{(String)entry.getKey()});
            }
            HashSet<String> hashSet = set;
            return hashSet;
        }
    }

    private Map<String, List<String>> getRegistryUrls() {
        ZookeeperClient zkclient = DubboHealthManager.getZkClient();
        Set<String> rootPaths = DubboHealthManager.getRootPaths();
        HashMap<String, List<String>> rmap = new HashMap<String, List<String>>(2);
        rootPaths.forEach(rootPath -> {
            List interfaces = zkclient.getChildren(rootPath);
            for (String interfaceI : interfaces) {
                String parent;
                List urls;
                if (LIVINGNODES.equals(interfaceI) || (urls = zkclient.getChildren(parent = rootPath + "/" + interfaceI + "/" + "providers")) == null || urls.size() <= 0) continue;
                rmap.put(parent, urls);
            }
        });
        return rmap;
    }

    public void end() {
        this.isStoped = true;
    }
}

