/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.configparser;

import com.alibaba.dubbo.common.compiler.support.ClassUtils;
import com.alibaba.dubbo.config.AbstractConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.rpc.dubbo.config.KDReferenceConfig;
import kd.bos.mservice.rpc.dubbo.config.KDServiceBean;
import kd.bos.mservice.rpc.dubbo.configparser.ConfigParser;

public class OldJSONConfigParser
extends ConfigParser {
    private static final Log log = LogFactory.getLog(OldJSONConfigParser.class);

    @Override
    public boolean supportKey(String key) {
        return key.endsWith(".json");
    }

    @Override
    public AbstractConfig[] parse(String key, String content) {
        if (!this.supportKey(key)) {
            return null;
        }
        return this._parse(key, content);
    }

    private AbstractConfig[] _parse(String key, String content) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonModel model = (JsonModel)mapper.readValue(content, JsonModel.class);
            ArrayList<AbstractConfig> configList = new ArrayList<AbstractConfig>();
            for (Definition def : model.definitions) {
                AbstractConfig config = this.parse(key, def);
                if (config == null) continue;
                configList.add(config);
            }
            if (configList.isEmpty()) {
                return null;
            }
            return configList.toArray(new AbstractConfig[configList.size()]);
        }
        catch (IOException e) {
            log.error("error when parse key:" + key, (Throwable)e);
            return null;
        }
    }

    private AbstractConfig parse(String key, Definition def) {
        String type = (String)def.get("type");
        try {
            if ("reference".equals(type)) {
                return this.parseReference(def);
            }
            if ("service".equals(type)) {
                return this.parseService(def);
            }
            log.error("error when parse " + key + ",unknow type:" + type);
            return null;
        }
        catch (Error | Exception t) {
            log.error("error when parse " + key, t);
            return null;
        }
    }

    private AbstractConfig parseService(Definition def) throws ClassNotFoundException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)def);
        String interfaze = props.getProperty("interface");
        String clazz = props.getProperty("class");
        if (clazz == null) {
            clazz = interfaze + "Impl";
        }
        String timeout = props.getProperty("timeout");
        Class<?> model = Class.forName(interfaze);
        Object bean = ClassUtils.newInstance((String)clazz);
        KDServiceBean service = new KDServiceBean();
        service.setInterface(model);
        service.setRef(bean);
        if (timeout != null) {
            service.setTimeout(Integer.parseInt(timeout.trim()));
        }
        String[] appIds = this.getAppIds(props);
        service.setAppIds(appIds);
        return service;
    }

    private String[] getAppIds(Properties props) {
        String str = props.getProperty("appIds");
        if (str == null) {
            return Instance.getAppIds();
        }
        return Instance.parseAppIds((String)str);
    }

    private AbstractConfig parseReference(Definition def) throws ClassNotFoundException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)def);
        String id = props.getProperty("id");
        String interfaze = props.getProperty("interface");
        String timeout = props.getProperty("timeout");
        String url = props.getProperty("url");
        if (url == null) {
            url = System.getProperty("dubbo.consumer.url");
        }
        Class<?> model = Class.forName(interfaze);
        KDReferenceConfig ref = new KDReferenceConfig();
        ref.setId(id);
        ref.setInterface(model);
        if (url != null) {
            ref.setUrl(url);
        }
        if (timeout != null) {
            ref.setTimeout(Integer.parseInt(timeout.trim()));
        }
        return ref;
    }

    static class Definition
    extends HashMap<String, String> {
        Definition() {
        }
    }

    static class JsonModel {
        private List<Definition> definitions = new ArrayList<Definition>();

        JsonModel() {
        }

        public List<Definition> getDefinitions() {
            return this.definitions;
        }

        public void setDefinitions(List<Definition> definitions) {
            this.definitions = definitions;
        }
    }
}

