/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.configparser;

import com.alibaba.dubbo.common.compiler.support.ClassUtils;
import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.MethodConfig;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.rpc.dubbo.config.KDReferenceConfig;
import kd.bos.mservice.rpc.dubbo.config.KDServiceBean;
import kd.bos.mservice.rpc.dubbo.configparser.ConfigParser;

public class PropertiesConfigParser
extends ConfigParser {
    private static final Log log = LogFactory.getLog(PropertiesConfigParser.class);
    public static final String ext_service = ".service";
    public static final String ext_consumer = ".consumer";

    @Override
    public boolean supportKey(String key) {
        return key.endsWith(ext_service) || key.endsWith(ext_consumer);
    }

    @Override
    public AbstractConfig[] parse(String key, String content) {
        AbstractConfig config = null;
        try {
            if (key.endsWith(ext_service)) {
                config = this.parseServiceConfig(key.substring(0, key.length() - ext_service.length()), content);
            } else if (key.endsWith(ext_consumer)) {
                config = this.parseReferenceConfig(key.substring(0, key.length() - ext_consumer.length()), content);
            }
            if (config == null) {
                return null;
            }
            return new AbstractConfig[]{config};
        }
        catch (Error | Exception t) {
            log.error("error when parse dubbo config by key:" + key, t);
            throw new KDException(t, BosErrorCode.configParseException, new Object[]{key});
        }
    }

    private AbstractConfig parseReferenceConfig(String defaultInterface, String content) throws IOException, ClassNotFoundException {
        String url;
        Properties props = new Properties();
        props.load(new StringReader(content));
        String id = props.getProperty("id");
        String interfaze = props.getProperty("interface", defaultInterface);
        String timeout = props.getProperty("timeout");
        String async = props.getProperty("async");
        if (async == null) {
            async = System.getProperty("dubbo.consumer.async");
        }
        if ((url = props.getProperty("url")) == null) {
            url = System.getProperty("dubbo.consumer.url." + defaultInterface);
        }
        if (url == null) {
            url = System.getProperty("dubbo.consumer.url");
        }
        Class<?> model = Class.forName(interfaze);
        KDReferenceConfig ref = new KDReferenceConfig();
        ref.setId(id);
        ref.setInterface(model);
        if (url != null) {
            ref.setUrl(url);
        }
        if (timeout != null) {
            ref.setTimeout(Integer.parseInt(timeout.trim()));
        }
        String retries = props.getProperty("retries");
        String methodConfs = props.getProperty("methods");
        if (retries != null) {
            ref.setRetries(Integer.parseInt(retries.trim()));
        }
        if (methodConfs != null) {
            ref.setMethods(this.parseMethodConfig(methodConfs));
        }
        return ref;
    }

    private AbstractConfig parseServiceConfig(String defaultInterface, String content) throws IOException, ClassNotFoundException {
        Properties props = new Properties();
        props.load(new StringReader(content));
        String interfaze = props.getProperty("interface", defaultInterface);
        String clazz = props.getProperty("class");
        if (clazz == null) {
            clazz = interfaze + "Impl";
        }
        String timeout = props.getProperty("timeout");
        Class<?> model = Class.forName(interfaze);
        Object bean = ClassUtils.newInstance((String)clazz);
        String scope = props.getProperty("scope");
        if (scope == null) {
            scope = System.getProperty("dubbo.service." + interfaze + ".scope");
        }
        KDServiceBean service = new KDServiceBean();
        service.setInterface(model);
        service.setRef(bean);
        if (scope != null) {
            service.setScope(scope);
        }
        if (timeout != null) {
            service.setTimeout(Integer.parseInt(timeout.trim()));
        }
        String retries = props.getProperty("retries");
        String methodConfs = props.getProperty("methods");
        if (retries != null) {
            service.setRetries(Integer.parseInt(retries.trim()));
        }
        if (methodConfs != null) {
            service.setMethods(this.parseMethodConfig(methodConfs));
        }
        String[] appIds = this.getAppIds(props);
        service.setAppIds(appIds);
        return service;
    }

    private List<MethodConfig> parseMethodConfig(String methodConfStr) throws IOException {
        if (methodConfStr == null) {
            return null;
        }
        methodConfStr = methodConfStr.replace("[", "");
        String[] confs = (methodConfStr = methodConfStr.replace("]", "")).split(",");
        if (confs.length <= 0) {
            return null;
        }
        ArrayList<MethodConfig> methodConfigList = new ArrayList<MethodConfig>(confs.length);
        for (String conf : confs) {
            Properties prop = new Properties();
            prop.load(new StringReader(conf));
            String name = prop.getProperty("name");
            String timeout = prop.getProperty("timeout");
            String retries = prop.getProperty("retries");
            methodConfigList.add(this.createMethodConfig(name, timeout, retries));
        }
        return methodConfigList;
    }

    private MethodConfig createMethodConfig(String name, String timeout, String retries) {
        MethodConfig methodConfig = new MethodConfig();
        if (name != null) {
            methodConfig.setName(name);
        }
        if (timeout != null) {
            methodConfig.setTimeout(Integer.valueOf(Integer.parseInt(timeout)));
        }
        if (retries != null) {
            methodConfig.setRetries(Integer.valueOf(Integer.parseInt(retries)));
        }
        return methodConfig;
    }

    private String[] getAppIds(Properties props) {
        String str = props.getProperty("appIds");
        if (str == null) {
            return Instance.getAppIds();
        }
        return Instance.parseAppIds((String)str);
    }
}

