/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.debug;

import com.alibaba.dubbo.common.URL;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kd.bos.debug.DebugInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.debug.DebugUtil;
import kd.bos.mservice.rpc.dubbo.context.KDInvokeContext;

public class DubboDebugUtil {
    private static final Log log = LogFactory.getLog((String)"mservice");

    public static String getRouteKey(URL url) {
        return url.getHost() + "#" + url.getProtocol() + "#" + url.getPort();
    }

    public static <T> T invoke(KDInvokeContext ctx, Callable<T> invoker, Supplier<String> invokerInfo) throws Exception {
        DebugInfo di;
        if (!DebugUtil.dev_log_sysout && log.isDebugEnabled()) {
            log.debug("#" + (String)DebugUtil.wrapInvokerInfoSupplier(invokerInfo).get());
        }
        if (ctx != null && ctx.getRequestContext() != null && (di = ctx.getRequestContext().getDebugInfo()) != null && di.getDebugId() != null && !"null".equals(di.getDebugId())) {
            if (di.isCmd()) {
                return (T)DebugUtil.runAtDebugCmdThread.invoke(null, di.getDebugId(), invoker, DebugUtil.wrapInvokerInfoSupplier(invokerInfo));
            }
            return (T)DebugUtil.runAtDebugMainThread.invoke(null, di.getDebugId(), invoker, DebugUtil.wrapInvokerInfoSupplier(invokerInfo));
        }
        return invoker.call();
    }
}

