/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.debug;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kd.bos.context.RequestContext;
import kd.bos.debug.DebugInfo;
import kd.bos.mservice.debug.DebugUtil;
import kd.bos.mservice.rpc.dubbo.context.KDInvokeContext;
import kd.bos.mservice.rpc.dubbo.debug.DubboDebugUtil;

public class LocalDebugProxy {
    public static <T> T debugProxy(Class<T> clazz, final T obj) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RequestContext rc = RequestContext.get();
                if (rc == null) {
                    try {
                        return method.invoke(obj, args);
                    }
                    catch (Throwable e) {
                        if (e instanceof InvocationTargetException) {
                            e = ((InvocationTargetException)e).getTargetException();
                        }
                        throw e;
                    }
                }
                KDInvokeContext ctx = new KDInvokeContext();
                ctx.setRequestContext(rc);
                try {
                    return DubboDebugUtil.invoke(ctx, () -> {
                        RequestContext.set((RequestContext)rc);
                        DebugInfo.setupThreadDebug((DebugInfo)rc.getDebugInfo());
                        return method.invoke(obj, args);
                    }, () -> method.getDeclaringClass().getName() + "." + method.getName() + "(" + DebugUtil.argumentsInfo((Object[])args) + ")");
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    throw e;
                }
            }
        });
    }
}

