/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.debug.router;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.cluster.Router;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bundle.Resources;
import kd.bos.dlock.DLock;
import kd.bos.mservice.debug.DebugUtil;
import kd.bos.mservice.debug.conf.DebugAttachConf;
import kd.bos.mservice.rpc.dubbo.debug.DubboDebugUtil;

public class DebugRouter
implements Router {
    private final AtomicInteger roundrobin = new AtomicInteger();
    private final URL url;
    private static final String BOS_DUBBOSERVICE = "bos-mservice-dubbox";

    public DebugRouter(URL url) {
        this.url = url;
    }

    public int compareTo(Router o) {
        return 0;
    }

    public URL getUrl() {
        return this.url;
    }

    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        if (!"consumer".equals(url.getParameter("side"))) {
            return invokers;
        }
        if (!DebugUtil.isDebugMode()) {
            return invokers;
        }
        String debugId = DebugUtil.getDebugId();
        String lockKey = "debug_route_" + debugId;
        ArrayList<Invoker<T>> ret = new ArrayList<Invoker<T>>(1);
        Invoker<T> stickyInvoker = null;
        boolean useSticky = true;
        DebugAttachConf conf = DebugAttachConf.get();
        long timeout = 600000L;
        try (DLock lock = DLock.create((String)lockKey).fastMode();){
            if (!lock.tryLock(600000L)) {
                throw new IllegalStateException(Resources.get((String)BOS_DUBBOSERVICE, (String)"DebugRouter_0", (String)"\u8c03\u8bd5\u83b7\u53d6\u9501%1$s\u8d85\u65f6(%2$s\u6beb\u79d2),\u670d\u52a1\u8c03\u7528url\u4e3a: %3$s", (Object[])new Object[]{lockKey, 600000L, url}));
            }
            String stickRouteKey = conf.getRouteKey(debugId);
            if (stickRouteKey != null) {
                for (Invoker<T> invoker : invokers) {
                    if (!stickRouteKey.equals(DubboDebugUtil.getRouteKey(invoker.getUrl()))) continue;
                    stickyInvoker = invoker;
                    break;
                }
            }
            if (stickyInvoker == null) {
                Object[] args;
                boolean cmdThread = DebugUtil.isCMDThread();
                if (cmdThread && (args = invocation.getArguments()).length >= 3 && "kd.bos.service.ServiceFactory".equals(args[0]) && "DebugService".equals(args[1]) && !"start".equals(args[2]) && !"keepAlive".equals(args[2])) {
                    throw new IllegalStateException(kd.bos.util.resource.Resources.getString((String)"\u8c03\u8bd5\u670d\u52a1\u8282\u70b9\u5df2\u65ad\u8fde\u3002", (String)"DebugRouter_2", (String)BOS_DUBBOSERVICE, (Object[])new Object[0]));
                }
                useSticky = false;
                stickyInvoker = invokers.get(this.roundrobin.getAndIncrement() % invokers.size());
                conf.attach(debugId, DubboDebugUtil.getRouteKey(stickyInvoker.getUrl()));
            }
        }
        ret.add(stickyInvoker);
        DebugUtil.debug((String)("useSticky=" + useSticky + "\tdebugId=" + debugId + "\t" + stickyInvoker.getUrl().toIdentityString()));
        return ret;
    }
}

