/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import kd.bos.cache.redis.CacheLimiter;
import kd.bos.db.DBLimiter;
import kd.bos.thread.OutOfMemoryObserver;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.thread.ThreadTruck;

@Activate(group={"provider"}, order=-8000)
public class ThreadLifeCycleFilter
implements Filter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            ThreadLifeCycleManager.start();
            CacheLimiter.init();
            DBLimiter.init();
            ThreadTruck.put((Object)"limiter.is_web_rpc", (Object)true);
            Result result = invoker.invoke(invocation);
            return result;
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryObserver.onOutOfMemory((OutOfMemoryError)e);
            throw e;
        }
        finally {
            ThreadLifeCycleManager.end();
        }
    }
}

