/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.filter.trace;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import kd.bos.govern.GovernConfigs;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.rpc.dubbo.filter.DubboArgumentsParser;
import kd.bos.mservice.rpc.dubbo.filter.trace.DubboSpanInjector;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.SpanInjector;
import kd.bos.trace.reporter.apicall.APICallTagInject;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

@Activate(group={"consumer"}, order=-9000)
public class ConsumerSpanFilter
implements Filter {
    private static final String SPAN_SERVICE_TAG_NAME = "RpcServiceName";
    private SpanInjector<RpcContext> spanInjector = new DubboSpanInjector();
    private String ip = NetAddressUtils.getLocalIpAddress();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        boolean isTraceDubbo = TraceConfig.isTraceEnable() || GovernConfigs.getTopologyEnable() || GovernConfigs.getApicallEnable() || GovernConfigs.getBreakerEnable();
        TraceSpan traceSpan = null;
        try {
            Result result;
            if (isTraceDubbo) {
                URL url = invoker.getUrl();
                String[] serviceMethodArr = DubboArgumentsParser.getServiceAndMethodName(invoker, invocation);
                String serviceName = serviceMethodArr[0];
                String methodName = serviceMethodArr[1];
                if ("batchInvokeAction".equals(methodName)) {
                    methodName = (String)InnerThreadTruck.get((Object)"batchInvokeAction");
                    RpcContext.getContext().getAttachments().put("batchInvokeAction", methodName);
                }
                String spanName = "consumer(" + this.ip + ") " + methodName;
                StringBuilder serviceNameBuild = new StringBuilder(spanName);
                String appId = url.getParameter("group");
                serviceNameBuild.append("[").append(serviceName).append(".").append(methodName).append("]");
                if (StringUtils.isNotEmpty((String)appId)) {
                    serviceNameBuild.append("/").append(appId);
                }
                if (TraceConfig.isTraceEnable()) {
                    traceSpan = Tracer.create((String)"RpcRequest", (String)serviceNameBuild.toString(), (boolean)true);
                    traceSpan.addTag(SPAN_SERVICE_TAG_NAME, this.getServiceName(invoker), true);
                    this.spanInjector.inject(traceSpan.getInnerSpan(), (Object)RpcContext.getContext());
                    traceSpan.logEvent("cs");
                } else if (GovernConfigs.getTopologyEnable() || GovernConfigs.getApicallEnable()) {
                    traceSpan = Tracer.create((String)"RpcRequest", (String)serviceNameBuild.toString(), (boolean)true);
                }
                if (traceSpan != null) {
                    String ip = url.getIp();
                    String destInstance = ServiceInfoFactory.get().getInstanceIdByIp(url.getIp());
                    if (serviceName != null && methodName != null) {
                        APICallTagInject.setMserviceTag((InnerSpan)traceSpan.getInnerSpan(), (String)this.ip, (String)url.getAddress(), (String)"dubbo", (String)serviceName, (String)methodName, (String)appId, (String)destInstance);
                    }
                    TopologyTagInject.setMserviceTag((InnerSpan)traceSpan.getInnerSpan(), (String)ServiceInfoFactory.get().getAppNameByIp(ip), (String)url.getProtocol(), (String)destInstance, (String)appId);
                }
            }
            Result result2 = result = invoker.invoke(invocation);
            return result2;
        }
        finally {
            if (traceSpan != null) {
                traceSpan.logEvent("cr");
                traceSpan.close();
            }
        }
    }

    private String getServiceName(Invoker<?> invoker) {
        String type = invoker.getUrl().getParameter("interface");
        return type.substring(type.lastIndexOf(".") + 1);
    }
}

