/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.filter.trace;

import com.alibaba.dubbo.rpc.RpcContext;
import java.util.Map;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.SpanInjector;

public class DubboSpanInjector
implements SpanInjector<RpcContext> {
    public void inject(InnerSpan span, RpcContext carrier) {
        Long parentId;
        long spanId;
        Map attachments = carrier.getAttachments();
        long traceId = span.getTraceId();
        if (traceId != 0L) {
            attachments.put("X-B3-TraceId", InnerSpan.idToHex((long)traceId));
        }
        if ((spanId = span.getSpanId()) != 0L) {
            attachments.put("X-B3-SpanId", InnerSpan.idToHex((long)spanId));
        }
        attachments.put("X-Span-Name", span.getName());
        attachments.put("X-B3-Sampled", span.isExportable() ? "1" : "0");
        attachments.put("service", span.tags().get("service"));
        Long l = parentId = span.getParents().size() > 0 ? (Long)span.getParents().get(0) : null;
        if (parentId != null && parentId != 0L) {
            attachments.put("X-B3-ParentSpanId", InnerSpan.idToHex((long)parentId));
        }
        attachments.put("X-Process-Id", span.getProcessId());
    }
}

