/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.registry.registryService.nacos;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.instance.Instance;
import kd.bos.util.SafeLogUtils;
import kd.bos.util.StringUtils;

public class NacosRegistryConfig {
    private static float weight = 1.0f;
    private static String clusterName = NacosRegistryConfig.genClusterName();
    private static boolean instanceEnabled = true;
    private static Map<String, String> metadata = new HashMap(){
        {
            this.put("preserved.heart.beat.interval", System.getProperty("nacos.provider.heart.beat.interval", "5000"));
            this.put("preserved.heart.beat.timeout", System.getProperty("nacos.provider.heart.beat.timeout", "15000"));
            this.put("preserved.ip.delete.timeout", System.getProperty("nacos.provider.ip.delete.timeout", "30000"));
            this.put("protocol", "nacos");
        }
    };
    private static boolean ephemeral = Boolean.parseBoolean(System.getProperty("ephemeral", "true"));

    public static void init() {
    }

    private static String genClusterName() {
        String cn = Instance.getClusterName();
        try {
            String regex = "[^a-zA-Z0-9]";
            cn = cn.replaceAll(regex, "");
            SafeLogUtils.info(NacosRegistryConfig.class, (String)("nacosregistry config,cluserName is " + cn));
        }
        catch (Exception e) {
            SafeLogUtils.error(NacosRegistryConfig.class, (String)"cn", (Throwable)e);
        }
        return StringUtils.isEmpty((String)cn) ? "DEFAULT" : cn;
    }

    public static float getWeight() {
        return weight;
    }

    public static String getClusterName() {
        return clusterName;
    }

    public static boolean isInstanceEnabled() {
        return instanceEnabled;
    }

    public static Map<String, String> getMetadata() {
        return metadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, HashMap::new));
    }

    public static boolean isEphemeral() {
        return ephemeral;
    }
}

