/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.registry.registryService.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.Properties;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.rpc.dubbo.config.KDRegistryConfig;
import kd.bos.util.StringUtils;

public class NacosRegistryService {
    private static final Log logger = LogFactory.getLog(NacosRegistryService.class);
    private static NamingService namingService;

    public static void init(KDRegistryConfig registry) {
        for (int i = 0; i < 5; ++i) {
            try {
                String nameSpace;
                Properties properties = new Properties();
                properties.put("serverAddr", registry.getAddress());
                if (StringUtils.isNotEmpty((String)registry.getUsername()) && StringUtils.isNotEmpty((String)registry.getUsername())) {
                    properties.put("username", registry.getUsername());
                    properties.put("password", registry.getPassword());
                }
                if (StringUtils.isNotEmpty((String)(nameSpace = System.getProperty("nacos.registry.namespace")))) {
                    properties.put("namespace", nameSpace);
                }
                namingService = NacosFactory.createNamingService((Properties)properties);
                break;
            }
            catch (Exception e) {
                logger.error("namingService init fail", (Throwable)e);
                continue;
            }
        }
    }

    public static NamingService getNamingService() {
        return namingService;
    }
}

