/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.rpc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.instance.Instance;

public class RequestStatus {
    private static Map<String, AtomicLong> appRequestCountMap = new ConcurrentHashMap<String, AtomicLong>(8);
    private static AtomicLong totalRequest = new AtomicLong(1L);

    public static void requestApp(String appid) {
        if (!Instance.isAppSplit() || appid == null) {
            return;
        }
        RequestStatus.get(appid).getAndIncrement();
        totalRequest.getAndIncrement();
    }

    public static boolean isAppRequestFrequency(String appid) {
        if (!Instance.isAppSplit() || appid == null) {
            return true;
        }
        return (double)RequestStatus.get(appid).get() / (double)totalRequest.get() > 0.01;
    }

    private static AtomicLong get(String appid) {
        return appRequestCountMap.computeIfAbsent(appid, k -> new AtomicLong(0L));
    }
}

