/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client;

import kd.bos.config.client.util.ConfigUtils;
import kd.bos.util.SystemProperties;

public class ConfigForDefaultProperties {
    public static void setRegistryProperty() {
        if ("true".equals(System.getProperty("bos.zookeeper.notuse"))) {
            ConfigForDefaultProperties.setPropertyIfEmpty("configUrl.type", "nacos");
            ConfigForDefaultProperties.setPropertyIfEmpty("mservice.discovery.type", "nacos");
            ConfigForDefaultProperties.setPropertyIfEmpty("IDService.assigner.type", "redis");
            ConfigForDefaultProperties.setPropertyIfEmpty("DLock.type", "redis");
            ConfigForDefaultProperties.setPropertyIfEmpty("algox.ha.type", "redis");
            ConfigForDefaultProperties.setPropertyIfEmpty("bos.zoowhisper.type", "redis");
        }
        if ("true".equals(System.getProperty("kregistrycenter.enable"))) {
            System.setProperty("dubbo.registry.protocol", "kregistrycenter");
        }
    }

    public static void setConfigProperty() {
        String configType = ConfigUtils.getConfigUrlType();
        if (!"zookeeper".equals(configType) && !"nacos".equals(configType)) {
            ConfigForDefaultProperties.setPropertyIfEmpty("enableKConfigService", "true");
        }
        if (ConfigUtils.isKCommonConfigServiceEnable() && !"zookeeper".endsWith(configType)) {
            ConfigForDefaultProperties.setPropertyIfEmpty("IDService.assigner.type", "redis");
            ConfigForDefaultProperties.setPropertyIfEmpty("DLock.type", "redis");
            ConfigForDefaultProperties.setPropertyIfEmpty("algox.ha.type", "redis");
            ConfigForDefaultProperties.setPropertyIfEmpty("bos.zoowhisper.type", "redis");
        }
    }

    private static void setPropertyIfEmpty(String key, String value) {
        String k;
        String oldValue;
        if (SystemProperties.getWithEnv((String)key) == null) {
            System.setProperty(key, value);
        }
        String nk = (oldValue = System.getProperty(k = "bos.zookeeper.notuse.subkey")) == null || oldValue.length() == 0 ? key : oldValue + "," + key;
        System.setProperty(k, nk);
    }
}

