/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client;

import kd.bos.config.client.Configuration;
import kd.bos.config.client.impl.ConfigurationFactoryNew;
import kd.bos.env.Env;
import kd.bos.util.SafeLogUtils;

public abstract class ConfigurationFactory {
    private static ConfigurationFactory instance;

    public abstract Configuration _getGlobalConfiguration();

    protected abstract Configuration _getConfigurationByPath(String var1);

    public void _reinit() {
    }

    public static Configuration getGlobalConfiguration() {
        return instance._getGlobalConfiguration();
    }

    public static Configuration getConfigurationByPath(String path) {
        return instance._getConfigurationByPath(path);
    }

    public static void reinit() {
        instance._reinit();
    }

    static {
        try {
            String className = Env.getConfigureClassName();
            instance = (ConfigurationFactory)Class.forName(className).newInstance();
        }
        catch (Error | Exception e) {
            SafeLogUtils.error(ConfigurationFactory.class, (String)"get ConfigurationFactory Impl from env error,will use default ", (Throwable)e);
            instance = new ConfigurationFactoryNew();
        }
    }
}

