/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.abc;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.abc.ArrayValue;
import kd.bos.config.client.abc.SystemPropertySetter;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import org.apache.log4j.Logger;

public class ABCConfiguration
extends Configuration {
    private static Logger logger = Logger.getLogger(ABCConfiguration.class);
    private static final String PRO_SPLIT = ".properties";
    private int n;
    private Configuration[] configurations;
    private HashMap<String, ArrayValue> map = new HashMap();
    private SystemPropertySetter systemPropertySetter;

    public ABCConfiguration(Configuration[] configurations, SystemPropertySetter systemPropertySetter) {
        this.systemPropertySetter = systemPropertySetter;
        this.n = configurations.length;
        this.configurations = configurations;
        this.init();
        this.initSystemProperties();
        for (int i = 0; i < this.n; ++i) {
            configurations[i].addConfigurationChangeListener(new MyListener(i));
        }
    }

    private void initSystemProperties() {
        this.map.forEach((key, av) -> this.setSystemProperty((String)key, av.get()));
    }

    private void setSystemProperty(String key, String value) {
        if (!key.endsWith(PRO_SPLIT)) {
            this.systemPropertySetter.set(key, value);
        }
    }

    private void init() {
        boolean firstLevel = true;
        for (int i = this.n - 1; i >= 0; --i) {
            Iterator<String> iter = this.configurations[i].keys();
            while (iter.hasNext()) {
                this.setMapValue(iter, i, firstLevel);
            }
            firstLevel = false;
        }
    }

    private void setMapValue(Iterator<String> iter, int i, boolean firstLevel) {
        ArrayValue av;
        String key = iter.next();
        String value = this.configurations[i].getProperty(key);
        if (firstLevel) {
            av = new ArrayValue(this.n);
            this.map.put(key, av);
        } else {
            av = this.map.get(key);
            if (av == null) {
                av = new ArrayValue(this.n);
                this.map.put(key, av);
            }
        }
        av.set(i, value);
        if (key.endsWith(PRO_SPLIT)) {
            this.createProperties(i, key, value);
        }
    }

    private void onAddProperties(int index, String key, String value) {
        Properties prop = new Properties();
        try {
            prop.load(new StringReader(value));
            for (String name : prop.stringPropertyNames()) {
                ArrayValue av = this.map.get(name);
                String oldValue = null;
                if (av == null) {
                    av = new ArrayValue(this.n);
                    this.map.put(name, av);
                } else if (av.get(index) != null) {
                    oldValue = av.get();
                }
                av.setInProperties(index, prop.getProperty(name));
                String newValue = av.get();
                if (newValue.equals(oldValue)) continue;
                this.fireChanged(name, newValue);
            }
        }
        catch (IOException e) {
            logger.error((Object)"onAddProperties error\uff1a", (Throwable)e);
        }
    }

    public void onUpdateProperties(int index, String key, String oldValue, String newValue) {
        Properties oldProp = new Properties();
        Properties newProp = new Properties();
        try {
            String afterPropValue;
            String beforePropValue;
            ArrayValue av;
            oldProp.load(new StringReader(oldValue));
            newProp.load(new StringReader(newValue));
            for (String name : newProp.stringPropertyNames()) {
                av = this.map.get(name);
                if (av == null) {
                    av = new ArrayValue(this.n);
                    this.map.put(name, av);
                }
                beforePropValue = av.get();
                av.setInProperties(index, newProp.getProperty(name));
                afterPropValue = av.get();
                if (!afterPropValue.equals(beforePropValue)) {
                    this.fireChanged(name, afterPropValue);
                }
                oldProp.remove(name);
            }
            for (String name : oldProp.stringPropertyNames()) {
                av = this.map.get(name);
                beforePropValue = av.get();
                av.setInProperties(index, null);
                afterPropValue = av.get();
                if (afterPropValue != null && afterPropValue.equals(beforePropValue)) continue;
                this.fireChanged(name, afterPropValue);
            }
        }
        catch (IOException e) {
            logger.error((Object)"onUpdateProperties error:", (Throwable)e);
        }
    }

    private void onRemoveProperties(int index, String key, String value) {
        Properties prop = new Properties();
        try {
            prop.load(new StringReader(value));
            for (String name : prop.stringPropertyNames()) {
                ArrayValue av = this.map.get(name);
                String oldValue = av.get();
                av.setInProperties(index, null);
                String newValue = av.get();
                if (newValue != null && newValue.equals(oldValue)) continue;
                this.fireChanged(name, newValue);
            }
        }
        catch (IOException e) {
            logger.error((Object)"onRemoveProperties error:", (Throwable)e);
        }
    }

    private void fireChanged(String key, String value) {
        if (value == null) {
            System.getProperties().remove(key);
        } else {
            this.setSystemProperty(key, value);
        }
        ConfigurationUtil.fireChanged((String)key, (Object)value);
        this.fireConfigurationChanged(key, value);
    }

    private void createProperties(int index, String key, String value) {
        Properties prop = new Properties();
        try {
            prop.load(new StringReader(value));
            for (String name : prop.stringPropertyNames()) {
                ArrayValue av = this.map.get(name);
                if (av == null) {
                    av = new ArrayValue(this.n);
                    this.map.put(name, av);
                } else if (av.get(index) != null) {
                    logger.warn((Object)("Config item " + name + " of " + key + " defined twice."));
                }
                av.setInProperties(index, prop.getProperty(name));
            }
        }
        catch (IOException e) {
            logger.error((Object)"createProperties error:", (Throwable)e);
        }
    }

    @Override
    public Iterator<String> keys() {
        return this.map.keySet().iterator();
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        ArrayValue av = this.map.get(key);
        if (av == null) {
            return defaultValue;
        }
        return av.get();
    }

    public class MyListener
    implements ConfigurationChangeListener {
        private int index;

        public MyListener(int index) {
            this.index = index;
        }

        private void buildArrayValue(ArrayValue av, Object key, Object value) {
            av = new ArrayValue(ABCConfiguration.this.n);
            ABCConfiguration.this.map.put((String)key, av);
            av.set(this.index, (String)value);
            ABCConfiguration.this.setSystemProperty((String)key, (String)value);
            ConfigurationUtil.fireChanged((String)((String)key), (Object)av.get());
            ABCConfiguration.this.fireConfigurationChanged(key, av.get());
            if (((String)key).endsWith(ABCConfiguration.PRO_SPLIT)) {
                ABCConfiguration.this.onAddProperties(this.index, (String)key, (String)value);
            }
        }

        private void changeValue(ArrayValue av, Object key, String oldValue) {
            if (av.isEmpty()) {
                ABCConfiguration.this.map.remove(key);
                System.getProperties().remove(key);
                ConfigurationUtil.fireChanged((String)((String)key), null);
                ABCConfiguration.this.fireConfigurationChanged(key, null);
            } else {
                String v = av.get();
                if (!v.equals(oldValue)) {
                    ABCConfiguration.this.setSystemProperty((String)key, v);
                    ConfigurationUtil.fireChanged((String)((String)key), (Object)v);
                    ABCConfiguration.this.fireConfigurationChanged(key, v);
                }
            }
            if (((String)key).endsWith(ABCConfiguration.PRO_SPLIT)) {
                ABCConfiguration.this.onRemoveProperties(this.index, (String)key, oldValue);
            }
        }

        public void onChange(Object key, Object value) {
            ArrayValue av = (ArrayValue)ABCConfiguration.this.map.get(key);
            if (av == null) {
                this.buildArrayValue(av, key, value);
            } else {
                String oldValue = av.get(this.index);
                av.set(this.index, (String)value);
                if (value == null) {
                    this.changeValue(av, key, oldValue);
                } else {
                    String v = av.get(this.index);
                    if (!v.equals(oldValue)) {
                        ABCConfiguration.this.setSystemProperty((String)key, v);
                        ConfigurationUtil.fireChanged((String)((String)key), (Object)v);
                        ABCConfiguration.this.fireConfigurationChanged(key, v);
                    }
                    if (((String)key).endsWith(ABCConfiguration.PRO_SPLIT)) {
                        ABCConfiguration.this.onUpdateProperties(this.index, (String)key, oldValue, (String)value);
                    }
                }
            }
        }
    }
}

