/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.abc;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import kd.bos.config.client.Configuration;
import org.apache.log4j.Logger;

public class ApplicationPropertiesConfiguration
extends Configuration {
    private static Logger logger = Logger.getLogger(ApplicationPropertiesConfiguration.class);
    private static final String fileName = "app.properties";
    private Properties prop = null;

    public ApplicationPropertiesConfiguration() {
        try (InputStream in = this.getClass().getResourceAsStream("/app.properties");){
            if (in != null) {
                this.prop = new Properties();
                this.prop.load(in);
            }
        }
        catch (IOException e1) {
            logger.error((Object)"Load property file app.propertieserror.", (Throwable)e1);
        }
    }

    @Override
    public Iterator<String> keys() {
        if (this.prop == null) {
            return Collections.emptyIterator();
        }
        return Iterators.transform(this.prop.keySet().iterator(), (Function)new Function<Object, String>(){

            public String apply(Object key) {
                return (String)key;
            }
        });
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.prop == null) {
            return defaultValue;
        }
        return this.prop.getProperty(key, defaultValue);
    }
}

