/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.configcenter;

import com.netflix.config.DynamicWatchedConfiguration;
import com.netflix.config.WatchedConfigurationSource;
import java.util.Iterator;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.adapter.ApacheConfigurationListenerAdapter;
import kd.bos.config.client.configcenter.KConfigCenterConfigurationSource;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.apache.commons.configuration.event.ConfigurationListener;

public class KConfigCenterConfiguration
extends Configuration {
    private KConfigCenterConfigurationSource kccConfigSource;
    private final DynamicWatchedConfiguration kccConfiguration;

    public KConfigCenterConfiguration(String url, String clusterName, String configAppName, String configType) {
        this.kccConfigSource = new KConfigCenterConfigurationSource(url, clusterName, configAppName, configType);
        try {
            this.kccConfigSource.start();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.zookeepConfiguration, new Object[0]);
        }
        try {
            this.kccConfiguration = new DynamicWatchedConfiguration((WatchedConfigurationSource)this.kccConfigSource);
            this.kccConfiguration.setDelimiterParsingDisabled(true);
            this.kccConfiguration.addConfigurationListener((ConfigurationListener)new ApacheConfigurationListenerAdapter(this));
        }
        catch (Exception t) {
            throw new KDException((Throwable)t, BosErrorCode.zookeepConfiguration, new Object[0]);
        }
    }

    public DynamicWatchedConfiguration getZKConfiguration() {
        return this.kccConfiguration;
    }

    @Override
    public Iterator<String> keys() {
        return this.kccConfiguration.getKeys();
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.kccConfiguration.getString(key);
        return value == null ? defaultValue : value;
    }
}

