/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.configcenter;

import com.netflix.config.WatchedConfigurationSource;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.config.client.configcenter.KConfigCenterFactory;
import kd.bos.config.client.configcenter.KConfigCenterSource;
import kd.bos.config.client.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KConfigCenterConfigurationSource
implements WatchedConfigurationSource,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(KConfigCenterConfigurationSource.class);
    private List<WatchedUpdateListener> listeners = new CopyOnWriteArrayList<WatchedUpdateListener>();
    private KConfigCenterSource source;

    public KConfigCenterConfigurationSource(String url, String clusterName, String configAppName, String configType) {
        this.source = KConfigCenterFactory.getSourceForRegister(ConfigUtils.getCommonConfigUrlType(), url, clusterName, configAppName, configType);
    }

    public void start() {
        this.source.registListener(new CallBackEvent(){

            @Override
            public void fireAddedEvent(String key, String value) {
                HashMap<String, Object> added = new HashMap<String, Object>();
                added.put(key, value);
                this._fireEvent(added, null, null);
            }

            @Override
            public void fireUpdatedEvent(String key, String value) {
                HashMap<String, Object> updated = new HashMap<String, Object>();
                updated.put(key, value);
                this._fireEvent(null, updated, null);
            }

            @Override
            public void fireRemovedEvent(String key, String value) {
                HashMap<String, Object> removed = new HashMap<String, Object>();
                removed.put(key, value);
                this._fireEvent(null, null, removed);
            }

            private void _fireEvent(Map<String, Object> added, Map<String, Object> changed, Map<String, Object> deleted) {
                WatchedUpdateResult result = WatchedUpdateResult.createIncremental(added, changed, deleted);
                KConfigCenterConfigurationSource.this.fireEvent(result);
            }
        });
    }

    public Map<String, Object> getCurrentData() {
        logger.debug("getCurrentData() retrieving current data.");
        return this.source.getData();
    }

    public void addUpdateListener(WatchedUpdateListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeUpdateListener(WatchedUpdateListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    protected void fireEvent(WatchedUpdateResult result) {
        for (WatchedUpdateListener l : this.listeners) {
            try {
                l.updateConfiguration(result);
            }
            catch (Exception ex) {
                logger.error("Error in invoking WatchedUpdateListener", (Throwable)ex);
            }
        }
    }

    @Override
    public void close() {
        this.source.close();
    }

    public static interface CallBackEvent {
        public void fireAddedEvent(String var1, String var2);

        public void fireUpdatedEvent(String var1, String var2);

        public void fireRemovedEvent(String var1, String var2);
    }
}

