/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import kd.bos.config.client.ConfigForDefaultProperties;
import kd.bos.config.client.ConfigService;
import kd.bos.config.client.ConfigServiceFactory;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.config.client.abc.ABCConfiguration;
import kd.bos.config.client.abc.ApplicationPropertiesConfiguration;
import kd.bos.config.client.abc.SystemEnvConfiguration;
import kd.bos.config.client.abc.SystemPropertiesConfiguration;
import kd.bos.config.client.adapter.CommonConfiguration;
import kd.bos.config.client.adapter.ExtraConfiguration;
import kd.bos.config.client.configurl.ConfigUrlService;
import kd.bos.config.client.impl._Properties;
import kd.bos.config.client.spi.ExtraConfigService;
import kd.bos.config.client.util.ConfigUtils;
import kd.bos.config.client.var.VarChangeListener;
import kd.bos.config.client.var.VarItem;
import kd.bos.config.client.var.VarMap;
import kd.bos.config.client.var.VarProxyConfiguration;
import kd.bos.config.client.var.VarSystemPropertySetter;
import kd.bos.config.client.zk.ZookeeperConfiguration;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.ha.component.KeepAliveService;
import kd.bos.instance.Instance;
import kd.bos.util.SafeLogUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.log4j.Logger;

public class ConfigurationFactoryNew
extends ConfigurationFactory {
    private static Logger logger = Logger.getLogger(ConfigurationFactoryNew.class);
    private String configUrl = null;
    private String configUrlType = null;
    private String[] configAppName = null;
    private VarMap varMap = null;
    private ABCConfiguration abcConfiguration;
    private VarProxyConfiguration globalConfiguration = null;

    public ConfigurationFactoryNew() {
        this.init();
        try {
            ConfigForDefaultProperties.setRegistryProperty();
        }
        catch (Error | Exception e) {
            SafeLogUtils.error(ConfigurationFactoryNew.class, (String)"set default properties error", (Throwable)e);
        }
    }

    @Override
    public void _reinit() {
        if (this.varMap != null) {
            this.varMap.clear();
        }
        if (this.abcConfiguration != null) {
            this.abcConfiguration.clearListeners();
        }
        if (this.globalConfiguration != null) {
            this.globalConfiguration.clearListeners();
        }
        this.init();
    }

    private void init() {
        AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
        this.configUrl = this.getConfigUrlBySPI();
        if (this.configUrl == null) {
            this.configUrl = this.getConfigUrlByConfigFile();
        }
        if (this.configUrl == null) {
            this.configUrl = SystemProperties.getWithEnv((String)"configUrl");
            if (this.configUrl == null) {
                throw new KDException(BosErrorCode.zookeepConfiguration, new Object[]{"Config Url not assigned,configUrl"});
            }
        }
        this.configAppName = Instance.getConfigAppName();
        this.configUrlType = ConfigUtils.getConfigUrlType();
        ConfigService configService = ConfigServiceFactory.getConfigService(this.configUrlType);
        String[] needPros = configService.needProperties();
        if (needPros != null && needPros.length > 0) {
            for (String needP : needPros) {
                if (System.getProperty(needP) != null && System.getProperty(needP).length() != 0) continue;
                return;
            }
        }
        this.initVar();
        this.initGlobal();
        _Properties p = new _Properties(System.getProperties());
        System.setProperties(p);
        System.setProperty("mc.isstarted", "true");
        try {
            String property = this.globalConfiguration.getProperty("ha.component.enable", "false");
            if (Boolean.parseBoolean(property)) {
                System.setProperty("ha.component.enable", property);
                KeepAliveService.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getConfigUrlBySPI() {
        String configUrl = null;
        ServiceLoader<ConfigUrlService> serviceLoader = ServiceLoader.load(ConfigUrlService.class);
        Iterator<ConfigUrlService> itr = serviceLoader.iterator();
        while (itr.hasNext()) {
            try {
                ConfigUrlService configUrlServices = itr.next();
                if (!(configUrlServices instanceof ConfigUrlService)) continue;
                configUrl = configUrlServices.getConfigUrl();
                logger.info((Object)("ConfigurationFactoryNew getConfigUrlBySPI successfully loaded class: " + configUrlServices.getClass().getName()));
                if (configUrl == null) continue;
                return configUrl;
            }
            catch (Error | Exception e) {
                logger.warn((Object)("Load configUrlServices failed,errorMessage:" + e.getMessage()), e);
            }
        }
        return configUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getConfigUrlByConfigFile() {
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream("/app.properties");){
            if (inputStream == null) return null;
            properties.load(inputStream);
            String configUrl = properties.getProperty("configUrl");
            if (!StringUtils.isNotEmpty((String)configUrl)) return null;
            System.setProperty("configUrl", configUrl);
            String string = configUrl;
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initVar() {
        ConfigService configService = ConfigServiceFactory.getConfigService(this.configUrlType);
        if (configService.getVarConfigName() != null) {
            configService.setConfigAppName(configService.getVarConfigName());
            this.varMap = new VarMap(new CommonConfiguration(configService), new VarChangeListener(){

                @Override
                public void onChange(String refKey, String varName, String varValue) {
                    String value = ConfigurationFactoryNew.this.globalConfiguration.getProperty(refKey);
                    if (value != null) {
                        VarItem varItem = (VarItem)ConfigurationFactoryNew.this.varMap.get(varName);
                        value = varItem.transform(value);
                        System.setProperty(refKey, value);
                    }
                }
            });
        }
    }

    @Override
    public Configuration _getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    private void initGlobal() {
        AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
        ArrayList<Configuration> configurationList = new ArrayList<Configuration>();
        configurationList.add(new SystemPropertiesConfiguration());
        configurationList.add(new SystemEnvConfiguration());
        configurationList.add(new ApplicationPropertiesConfiguration());
        String extConfigLoadFirst = SystemProperties.getWithEnv((String)"configServer.extra.override.enable", (String)"true");
        boolean extConfigLoadFirstFlag = Boolean.parseBoolean(extConfigLoadFirst);
        if (extConfigLoadFirstFlag) {
            this.loadExtConfigServer(configurationList);
            this.loadCommonConfigServer(configurationList);
        } else {
            this.loadCommonConfigServer(configurationList);
            this.loadExtConfigServer(configurationList);
        }
        VarSystemPropertySetter vps = new VarSystemPropertySetter(this.varMap);
        this.abcConfiguration = new ABCConfiguration(configurationList.toArray(new Configuration[configurationList.size()]), vps);
        this.globalConfiguration = new VarProxyConfiguration(this.abcConfiguration, this.varMap);
    }

    private void loadCommonConfigServer(List<Configuration> configurationList) {
        for (int i = 0; i < this.configAppName.length; ++i) {
            String tempConfigAppName = this.configAppName[i];
            ConfigService configService = ConfigServiceFactory.getConfigService(this.configUrlType);
            configService.setConfigAppName(tempConfigAppName);
            configurationList.add(new CommonConfiguration(configService));
        }
        ConfigService configService = ConfigServiceFactory.getConfigService(this.configUrlType);
        configService.setConfigAppName("common");
        configurationList.add(new CommonConfiguration(configService));
    }

    private void loadExtConfigServer(List<Configuration> configurationList) {
        String[] configCenterArray;
        String extConfigCenters = SystemProperties.getWithEnv((String)"configServer.extra.types");
        if (StringUtils.isEmpty((String)extConfigCenters)) {
            return;
        }
        ExtensionFactory configSpiFactory = ExtensionFactory.getExtensionFacotry(ExtraConfigService.class);
        for (String tempConfigCenter : configCenterArray = extConfigCenters.split(",")) {
            for (int i = 0; i < this.configAppName.length; ++i) {
                String tempConfigAppName = this.configAppName[i];
                ExtraConfigService extExtraConfigService = (ExtraConfigService)configSpiFactory.getExtension(tempConfigCenter, false);
                extExtraConfigService.setConfigAppName(tempConfigAppName);
                configurationList.add(new ExtraConfiguration(extExtraConfigService));
            }
            ExtraConfigService extExtraConfigService = (ExtraConfigService)configSpiFactory.getExtension(tempConfigCenter, false);
            extExtraConfigService.setConfigAppName("common");
            configurationList.add(new ExtraConfiguration(extExtraConfigService));
        }
    }

    @Override
    public Configuration _getConfigurationByPath(String path) {
        String configUrlType = ConfigUtils.getConfigUrlType();
        if (configUrlType.equals("zookeeper") && !ConfigUtils.isKCommonConfigServiceEnable()) {
            return new ZookeeperConfiguration(this.configUrl, path);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService(configUrlType);
        configService.setConfigPath(path);
        return new CommonConfiguration(configService);
    }

    static {
        try {
            ConfigForDefaultProperties.setConfigProperty();
        }
        catch (Error | Exception e) {
            SafeLogUtils.error(ConfigurationFactoryNew.class, (String)"set default properties error", (Throwable)e);
        }
    }
}

