/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.impl;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.config.client.RuntimeGlobalProperties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.util.SystemProperties;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class RuntimeGlobalPropertiesImpl
extends RuntimeGlobalProperties {
    private static final Charset charset = Charset.forName("UTF-8");
    private CuratorFramework client;
    private Configuration configuration;
    private String rootPath = this.getPath();

    public RuntimeGlobalPropertiesImpl() {
        String zookeeper = System.getProperty("configUrl");
        this.client = ZKFactory.getZKClient((String)zookeeper);
        File file = new File(this.rootPath);
        try {
            this.createPath(this.client, file);
        }
        catch (Exception t) {
            throw new KDException((Throwable)t, BosErrorCode.configZookeepConfig, new Object[]{"create path failed:" + this.rootPath});
        }
        this.configuration = ConfigurationFactory.getConfigurationByPath(this.rootPath);
    }

    private void createPath(CuratorFramework client, File file) {
        if (file == null) {
            return;
        }
        String path = null;
        try {
            path = file.getPath().replaceAll("\\\\", "/");
            Stat exists = (Stat)client.checkExists().forPath(path);
            if (exists == null) {
                this.createPath(client, file.getParentFile());
                client.getZookeeperClient().getZooKeeper().create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.configZookeepConfig, new Object[]{"create path failed:" + path});
        }
    }

    private String getPath() {
        String configUrl = SystemProperties.getWithEnv((String)"configUrl");
        return ZKFactory.getZkRootPath((String)configUrl) + Instance.getClusterName() + "/runtime/globalproperties";
    }

    @Override
    public String _get(String key) {
        return this.configuration.getProperty(key);
    }

    @Override
    public void _put(String key, String value) {
        if (value != null && value.equals(this._get(key))) {
            return;
        }
        try {
            String path = this.rootPath + "/" + key;
            Stat exists = (Stat)this.client.checkExists().forPath(path);
            if (exists == null) {
                if (value != null) {
                    this.client.getZookeeperClient().getZooKeeper().create(path, value.getBytes(charset), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
            } else if (value != null) {
                this.client.getZookeeperClient().getZooKeeper().setData(path, value.getBytes(charset), -1);
            } else {
                this.client.getZookeeperClient().getZooKeeper().delete(path, -1);
            }
        }
        catch (Exception t) {
            throw new KDException((Throwable)t, BosErrorCode.configZookeepConfig, new Object[]{"put global property failed. key=" + key + ", value=" + value});
        }
    }
}

