/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.nacos;

import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import kd.bos.config.client.spi.ExtraConfigService;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.nacos.NacosConfigService;
import kd.bos.nacos.NacosFactory;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;
import org.yaml.snakeyaml.Yaml;

public class NacosExtraConfigService
implements ExtraConfigService {
    private static final String COMPLEX_DATAIDS = "complex.dataids";
    private static final String COMPLEX_PROPERTIE_SSUFFIX = ".properties";
    private static final String EMPTY_VALUE_NIL = "{nil}";
    private Map<String, String> innerConfigMap = new HashMap<String, String>();
    private Map<String, Listener> complexDataId_listener_map = new HashMap<String, Listener>();
    private String nacosConfigUrl = SystemProperties.getWithEnv((String)"configServer.extra.nacos.configUrl");
    private String namespace;
    private String group;
    private String dataId = "prop.properties";
    private NacosConfigService configService;

    public NacosExtraConfigService() {
        if (this.nacosConfigUrl == null) {
            throw new KDException(BosErrorCode.nacosConfiguration, new Object[]{"nacosConfigUrl not assigned,configServer.extra.nacos.configUrl"});
        }
        this.configService = NacosFactory.getNacosConfigClient((String)this.nacosConfigUrl);
        this.namespace = NacosFactory.getNacosNamespace((String)this.nacosConfigUrl);
    }

    @Override
    public Iterator<String> keys() {
        String config = null;
        try {
            config = this.configService.getConfigAndSignListener(this.dataId, this.group, new Listener(){

                public void receiveConfigInfo(String propConfig) {
                    try {
                        NacosExtraConfigService.this.loadPropProperties(propConfig);
                    }
                    catch (NacosException nacosException) {
                        // empty catch block
                    }
                }

                public Executor getExecutor() {
                    return null;
                }
            });
            this.loadPropProperties(config);
        }
        catch (NacosException e) {
            throw new KDException(BosErrorCode.nacosConfiguration, new Object[]{"getConfigError,namespace=" + this.getNacosNamespace() + ",group=" + this.getGroup() + ",dataId=" + this.getDataId()});
        }
        Set<String> innerConfigKeySet = this.innerConfigMap.keySet();
        ArrayList<String> tempKeyList = new ArrayList<String>(innerConfigKeySet.size());
        for (String tempConfigKey : innerConfigKeySet) {
            if (!tempConfigKey.endsWith(COMPLEX_PROPERTIE_SSUFFIX)) continue;
            tempKeyList.add(tempConfigKey);
        }
        for (String tempConfigKey : innerConfigKeySet) {
            if (tempKeyList.contains(tempConfigKey)) continue;
            tempKeyList.add(tempConfigKey);
        }
        return tempKeyList.iterator();
    }

    private void loadPropProperties(String propConfig) throws NacosException {
        if (StringUtils.isEmpty((String)propConfig)) {
            this.loadSimpleConfig(new HashMap<String, Object>());
            this.removeComplexConfigAndListener(null);
            return;
        }
        Properties properties = new Properties();
        StringReader reader = new StringReader(propConfig);
        try {
            properties.load(reader);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.nacosConfiguration, new Object[]{e.getMessage()});
        }
        HashMap<Object, Object> configMap = new HashMap<Object, Object>(properties);
        Object complexDataIdsObject = configMap.remove(COMPLEX_DATAIDS);
        if (complexDataIdsObject != null) {
            String[] tempDataIdsArray = complexDataIdsObject.toString().split(",");
            ArrayList complexDataIdList = new ArrayList();
            Collections.addAll(complexDataIdList, tempDataIdsArray);
            configMap.put(COMPLEX_DATAIDS, complexDataIdList);
        }
        this.loadSimpleConfig(configMap);
        this.loadComplexConfig(configMap);
    }

    private void loadPropYaml(String propConfig) throws NacosException {
        if (StringUtils.isEmpty((String)propConfig)) {
            this.removeComplexConfigAndListener(null);
            return;
        }
        Map configMap = (Map)new Yaml().load(propConfig);
        this.loadSimpleConfig(configMap);
        this.loadComplexConfig(configMap);
    }

    private void loadSimpleConfig(Map<String, Object> configMap) {
        HashMap<String, String> allConfigMap = new HashMap<String, String>(this.innerConfigMap);
        HashMap<String, String> complexConfigMap = new HashMap<String, String>();
        if (this.complexDataId_listener_map.size() > 0) {
            Set<String> complexDataIdSet = this.complexDataId_listener_map.keySet();
            for (String tempComplexDataId : complexDataIdSet) {
                String tempComplexValue = (String)allConfigMap.remove(tempComplexDataId);
                complexConfigMap.put(tempComplexDataId, tempComplexValue);
            }
        }
        HashMap<String, String> simpleConfigMap = allConfigMap;
        Iterator simpleDataIdIt = simpleConfigMap.keySet().iterator();
        while (simpleDataIdIt.hasNext()) {
            String tempSimpleDataId = ((String)simpleDataIdIt.next()).trim();
            if (configMap.containsKey(tempSimpleDataId)) continue;
            this.fireConfigurationChanged(tempSimpleDataId, null);
            simpleDataIdIt.remove();
        }
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            String key = entry.getKey().trim();
            Object value = entry.getValue();
            if (!(value instanceof String) && !(value instanceof Integer) && !(value instanceof Boolean) && !(value instanceof Float) && !(value instanceof Double) && !(value instanceof Long)) continue;
            String valueString = value.toString().trim();
            if (valueString.equals(EMPTY_VALUE_NIL)) {
                valueString = "";
            }
            simpleConfigMap.put(key, valueString);
            this.fireConfigurationChanged(key, valueString);
        }
        allConfigMap.putAll(complexConfigMap);
        this.innerConfigMap = allConfigMap;
    }

    private void loadComplexConfig(Map<String, Object> configMap) throws NacosException {
        if (configMap.containsKey(COMPLEX_DATAIDS)) {
            List complexDataIdList = (List)configMap.get(COMPLEX_DATAIDS);
            this.removeComplexConfigAndListener(complexDataIdList);
            this.loadComplexDataIds(complexDataIdList);
        } else {
            this.removeComplexConfigAndListener(null);
        }
    }

    private void removeComplexConfigAndListener(List<String> complexDataIdList) throws NacosException {
        if (complexDataIdList == null || complexDataIdList.size() == 0) {
            if (this.complexDataId_listener_map.size() > 0) {
                for (Map.Entry<String, Listener> tempEntry : this.complexDataId_listener_map.entrySet()) {
                    String string = tempEntry.getKey();
                    Listener listener = tempEntry.getValue();
                    this.configService.removeListener(string, this.group, listener);
                    this.innerConfigMap.remove(string);
                    this.fireConfigurationChanged(string, null);
                }
                this.complexDataId_listener_map.clear();
            }
            return;
        }
        if (this.complexDataId_listener_map.size() > 0) {
            HashMap<String, Listener> complexDataIdListenerMap = new HashMap<String, Listener>(complexDataIdList.size());
            for (final String string : complexDataIdList) {
                Listener complexDataIdListener = this.complexDataId_listener_map.get(string);
                if (complexDataIdListener == null) {
                    complexDataIdListener = new Listener(){

                        public Executor getExecutor() {
                            return null;
                        }

                        public void receiveConfigInfo(String complexConfig) {
                            if (string.endsWith(NacosExtraConfigService.COMPLEX_PROPERTIE_SSUFFIX)) {
                                complexConfig = complexConfig.replace(NacosExtraConfigService.EMPTY_VALUE_NIL, "");
                            }
                            NacosExtraConfigService.this.innerConfigMap.put(string, complexConfig);
                            NacosExtraConfigService.this.fireConfigurationChanged(string, complexConfig);
                        }
                    };
                    this.configService.addListener(string, this.group, complexDataIdListener);
                }
                complexDataIdListenerMap.put(string, complexDataIdListener);
            }
            for (Map.Entry entry : this.complexDataId_listener_map.entrySet()) {
                String tempDataId = (String)entry.getKey();
                Listener listener = (Listener)entry.getValue();
                if (complexDataIdList.contains(tempDataId)) continue;
                this.configService.removeListener(tempDataId, this.group, listener);
                this.innerConfigMap.remove(tempDataId);
                this.fireConfigurationChanged(tempDataId, null);
            }
            this.complexDataId_listener_map = complexDataIdListenerMap;
        } else {
            for (final String tempComplexDataId : complexDataIdList) {
                Listener listener = new Listener(){

                    public Executor getExecutor() {
                        return null;
                    }

                    public void receiveConfigInfo(String complexConfig) {
                        if (tempComplexDataId.endsWith(NacosExtraConfigService.COMPLEX_PROPERTIE_SSUFFIX)) {
                            complexConfig = complexConfig.replace(NacosExtraConfigService.EMPTY_VALUE_NIL, "");
                        }
                        NacosExtraConfigService.this.innerConfigMap.put(tempComplexDataId, complexConfig);
                        NacosExtraConfigService.this.fireConfigurationChanged(tempComplexDataId, complexConfig);
                    }
                };
                this.configService.addListener(tempComplexDataId, this.group, listener);
                this.complexDataId_listener_map.put(tempComplexDataId, listener);
            }
        }
    }

    private void loadComplexDataIds(List<String> complexDataIdList) throws NacosException {
        if (complexDataIdList == null || complexDataIdList.size() == 0) {
            return;
        }
        for (String tempComplexDataId : complexDataIdList) {
            tempComplexDataId = tempComplexDataId.trim();
            String tempComplexConfig = this.configService.getConfig(tempComplexDataId, this.group);
            if (tempComplexDataId.endsWith(COMPLEX_PROPERTIE_SSUFFIX)) {
                tempComplexConfig = tempComplexConfig.replace(EMPTY_VALUE_NIL, "");
            }
            this.innerConfigMap.put(tempComplexDataId, tempComplexConfig);
            this.fireConfigurationChanged(tempComplexDataId, tempComplexConfig);
        }
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.innerConfigMap.get(key);
        return value == null ? defaultValue : value;
    }

    private String getNacosNamespace() {
        return this.namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDataId() {
        return this.dataId;
    }

    @Override
    public void setConfigAppName(String configAppName) {
        this.group = configAppName;
    }

    @Override
    public String getConfigAppName() {
        return this.group;
    }

    @Override
    public String spiName() {
        return "nacos";
    }
}

