/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.util;

import java.util.Locale;
import kd.bos.config.client.ConfigUrlType;
import kd.bos.util.SystemProperties;
import kd.bos.zk.ZKFactory;

public class ConfigUtils {
    public static final String CLUSTER_NAME_KEY = "clusterName";
    public static final String APP_NAME_KEY = "appName";
    public static final String CONFIG_URL_KEY = "configUrl";
    public static final String NACOS_CONFIG_URL_KEY = "configServer.extra.nacos.configUrl";
    public static final String CONFIG_URL_TYPE_KEY = "configUrl.type";
    public static final String CONFIG_ROOTPATH_KEY = "configRootPath";
    public static final String NODE_NAME_KEY = "nodeName";
    public static final String NODE_CONFIG_PATH_KEY = "nodeConfigPath";
    public static final String CONFIGSERVER_URL_KEY = "configServerUrl";
    private static final String configRootPath = ConfigUtils.initRootPath();

    public static String getConfigUrlType() {
        String[] schemaAndUrl;
        String configUrlType = SystemProperties.getWithEnv((String)CONFIG_URL_TYPE_KEY);
        if (configUrlType != null && configUrlType.trim().length() > 0) {
            return configUrlType.trim();
        }
        String configUrl = SystemProperties.getWithEnv((String)CONFIG_URL_KEY);
        if (configUrl != null && configUrl.trim().length() > 0 && (schemaAndUrl = configUrl.trim().split("@")).length > 1 && ("db".equals(configUrlType = schemaAndUrl[0].toLowerCase(Locale.ENGLISH)) || "mc".equals(configUrlType))) {
            System.setProperty(CONFIG_URL_TYPE_KEY, configUrlType);
            return configUrlType;
        }
        return SystemProperties.getWithEnv((String)CONFIG_URL_TYPE_KEY, (String)"zookeeper");
    }

    public static boolean isKCommonConfigServiceEnable() {
        return "true".equals(SystemProperties.getWithEnv((String)"enableKConfigService"));
    }

    public static String getCommonConfigUrlType() {
        return ConfigUtils.getConfigUrlType();
    }

    public static ConfigUrlType getConfigUrlTypeEnum() {
        String configUrlType = ConfigUtils.getConfigUrlType();
        if (configUrlType.equals("nacos")) {
            return ConfigUrlType.nacos;
        }
        return ConfigUrlType.zookeeper;
    }

    private static String initRootPath() {
        String configUrl = SystemProperties.getWithEnv((String)CONFIG_URL_KEY);
        ConfigUrlType configUrlType = ConfigUtils.getConfigUrlTypeEnum();
        if (ConfigUrlType.zookeeper == configUrlType) {
            return ZKFactory.getZkRootPath((String)configUrl);
        }
        return "/";
    }

    public static String getCommonVarPath(String clusterName) {
        return configRootPath + clusterName + "/config/common/var";
    }

    public static String getCommonPropertyPath(String clusterName) {
        return configRootPath + clusterName + "/config/common/prop";
    }

    public static String getAppPropertyPath(String clusterName, String configAppName) {
        return configRootPath + clusterName + "/config/" + configAppName + "/prop";
    }

    public static String getAppServicePath(String clusterName, String configAppName) {
        return configRootPath + clusterName + "/config/" + configAppName + "/service";
    }

    public static String getConfigPath(String clusterName, String configAppName, String configtype) {
        return configRootPath + clusterName + "/config/" + configAppName + "/" + configtype;
    }
}

