/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.config.client.util.ClassUtils;
import kd.sdk.annotation.SdkInternal;
import org.apache.log4j.Logger;

@SdkInternal
public class StringUtils {
    private static Logger logger = Logger.getLogger(StringUtils.class);

    @SdkInternal
    public static boolean isEmpty(String string) {
        return StringUtils.isNull(string) || StringUtils.isBlank(string);
    }

    @SdkInternal
    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    @SdkInternal
    public static String getEmpty() {
        return "";
    }

    @SdkInternal
    public static boolean isNull(String string) {
        return string == null;
    }

    @SdkInternal
    public static boolean isNotNull(String string) {
        return !StringUtils.isNull(string);
    }

    @SdkInternal
    public static boolean isBlank(String string) {
        return StringUtils.isNotNull(string) && string.trim().length() == 0;
    }

    @SdkInternal
    public static String trim(String string) {
        if (StringUtils.isNull(string)) {
            return StringUtils.getEmpty();
        }
        return string.trim();
    }

    @SdkInternal
    public static Boolean toBoolean(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        return "true".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    @SdkInternal
    public static String dropString(String prefix, String value, boolean camelFirstLetter) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        String newValue = null;
        int preIndex = value.lastIndexOf(prefix);
        if (preIndex > 0) {
            newValue = value.substring(preIndex + prefix.length());
            if (StringUtils.isNotEmpty(newValue) && newValue.length() > 1 && camelFirstLetter) {
                return Character.toLowerCase(newValue.charAt(0)) + newValue.substring(1);
            }
            return newValue;
        }
        return value;
    }

    @SdkInternal
    public static String buildString(String prefix, String value, boolean captalFirstLetter) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        String newValue = null;
        if (captalFirstLetter) {
            newValue = Character.toUpperCase(value.charAt(0)) + value.substring(1);
        }
        return prefix + newValue;
    }

    @SdkInternal
    public static String valueOf(Class<?> type, Object value) {
        if (ClassUtils.isPrimitiveOrWrapper(type)) {
            return StringUtils.primitiveOrWrapper(value);
        }
        if (ClassUtils.isPrimitiveWrapperArray(type)) {
            return StringUtils.primitiveWrapperArray(value, type);
        }
        if (Map.class.isAssignableFrom(type)) {
            return StringUtils.assignableFrom(value);
        }
        return value.toString();
    }

    private static String primitiveOrWrapper(Object value) {
        if (value != null) {
            String result = String.valueOf(value);
            if ("true".equalsIgnoreCase(result)) {
                return "1";
            }
            if ("false".equalsIgnoreCase(result)) {
                return "0";
            }
            return value.toString();
        }
        return "";
    }

    private static String primitiveWrapperArray(Object value, Class<?> type) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Object[] array = (Object[])value;
        if (array == null) {
            return sb.append("]").toString();
        }
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Class<?> componentType = type.getComponentType();
            sb.append(StringUtils.valueOf(componentType, array[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    private static String assignableFrom(Object value) {
        Map result = (Map)value;
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (result == null) {
            return sb.append("}").toString();
        }
        Iterator itor = result.entrySet().iterator();
        int i = 0;
        while (itor.hasNext()) {
            Map.Entry entry = itor.next();
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(entry.getKey()).append(":").append(entry.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternal
    public static <T> T cast(Class<?> type, String value) {
        return null;
    }

    @SdkInternal
    public static String valueOf(String type, Object value) {
        if (StringUtils.isNotEmpty(type)) {
            String[] types = type.split("/");
            for (int i = 0; i < types.length; ++i) {
                try {
                    Class<?> clazz = ClassUtils.getDefaultClassLoader().loadClass(types[i]);
                    String result = StringUtils.valueOf(clazz, value);
                    return result;
                }
                catch (Exception e) {
                    logger.error((Object)("\u65e0\u6cd5\u52a0\u8f7d\u7c7b\u578b type:" + types[i]), (Throwable)e);
                    continue;
                }
            }
        }
        return null;
    }

    @SdkInternal
    public static List<String> getSubKey(String value, String spliter) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isNotEmpty(value)) {
            int index = value.lastIndexOf(spliter);
            String key = value;
            if (index > 0) {
                key = value.substring(index);
            }
            String[] values = value.split(spliter);
            StringBuilder pre = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                String preString;
                pre.append(values[i]);
                if (i > 0) {
                    pre.append(spliter);
                }
                if (!(preString = pre.toString()).endsWith(spliter)) {
                    result.add(preString + spliter + key);
                    continue;
                }
                result.add(preString + key);
            }
        }
        return result;
    }
}

