/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.util;

import java.util.HashMap;
import java.util.Map;

public class VarUtils {
    private static final String var_prefix = "{{";
    private static final String var_suffix = "}}";

    public static String get(String string, Map<String, String> varMap) {
        if (string == null) {
            return string;
        }
        if (varMap == null) {
            return string;
        }
        HashMap<String, String> lowerCaseVarMap = new HashMap<String, String>(varMap.size());
        for (Map.Entry<String, String> entry : varMap.entrySet()) {
            lowerCaseVarMap.put(entry.getKey().toLowerCase().trim(), entry.getValue());
        }
        StringBuilder s = new StringBuilder(string.length() + 100);
        String seg = string;
        while (true) {
            int p1;
            if ((p1 = seg.indexOf(var_prefix)) == -1) {
                s.append(seg);
                break;
            }
            s.append(seg.substring(0, p1));
            seg = seg.substring(p1 + var_prefix.length());
            int p2 = seg.indexOf(var_suffix);
            if (p2 == -1) {
                s.append(seg);
                break;
            }
            String name = seg.substring(0, p2).trim().toLowerCase();
            String value = (String)lowerCaseVarMap.get(name);
            if (value == null) {
                throw new IllegalArgumentException("Variable " + name + " not configured.");
            }
            s.append(value);
            seg = seg.substring(p2 + var_suffix.length());
        }
        return s.toString();
    }
}

