/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.var;

import java.util.HashSet;

public class VarItem {
    private String varName;
    private String varValue;
    private HashSet<String> refs = new HashSet(2);
    private String pattern;

    public VarItem(String varName, String varValue) {
        this.varName = varName;
        if (varValue.indexOf("$") >= 0) {
            varValue = varValue.replace("$", "\\$");
        }
        this.varValue = varValue;
        this.pattern = "\\{\\{" + varName + "\\}\\}";
    }

    public String getVarName() {
        return this.varName;
    }

    public String getVarValue() {
        return this.varValue;
    }

    public HashSet<String> getRefs() {
        return this.refs;
    }

    public void addRef(String key) {
        this.refs.add(key);
    }

    public void removeRef(String key) {
        this.refs.remove(key);
    }

    public String transform(String value) {
        return value.replaceAll(this.pattern, this.varValue);
    }

    public void setVarValue(String varValue) {
        this.varValue = varValue;
    }
}

