/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.logrule;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LogRuleHistoricalDataClean {
    private static final Log log = LogFactory.getLog(LogRuleHistoricalDataClean.class);

    public static void clear() {
        try {
            DBRequest dbRequest = LogRuleHistoricalDataClean.getClearHystroyRequest();
            MetadataFactory.getStatement().executeDelete(dbRequest);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    private static DBRequest getClearHystroyRequest() {
        DBRequest dbRequest = new DBRequest();
        String deleteSql = "delete from T_MONITOR_LOG_RULE_CONFIG where fid in (select top 2000,0 fid from T_MONITOR_LOG_RULE_CONFIG where fupdatetime < ?)";
        ArrayList deleteList = new ArrayList(1);
        Collections.addAll(deleteList, LocalDate.now().minusMonths(Integer.getInteger("gov.log.rule.Historical.month", 1).intValue()));
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
        return dbRequest;
    }
}

