/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.metadata.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ApiMetadataHistoricalDataClean {
    private static Log log = LogFactory.getLog(ApiMetadataHistoricalDataClean.class);

    public static void clear() {
        try {
            DBRequest dbRequest = ApiMetadataHistoricalDataClean.getClearHystroyRequest();
            MetadataFactory.getStatement().executeDelete(dbRequest);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    private static DBRequest getClearHystroyRequest() {
        DBRequest dbRequest = new DBRequest();
        String deleteSql = "delete from t_monitor_api_metadata where fid in (select top 2000,0 fid from t_monitor_api_metadata where fupdatetime < ?)";
        ArrayList deleteList = new ArrayList(1);
        Collections.addAll(deleteList, LocalDate.now().minusMonths(Integer.getInteger("gov.api.metadata.Historical.month", 2).intValue()));
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
        return dbRequest;
    }

    public static void updateHystroyData() {
        try {
            DBRequest dbRequest = new DBRequest();
            String updateSql = "update t_monitor_api_metadata set fappid= ? where fclustername= ? and fappid= ?";
            ArrayList updateList = new ArrayList(3);
            Collections.addAll(updateList, " ", Instance.getClusterName(), "");
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
            MetadataFactory.getStatement().executeUpdate(dbRequest);
        }
        catch (Exception e) {
            log.warn("ApiMetadataHistoricalDataClean updateHystroyData exception:", (Throwable)e);
        }
    }

    private static DBRequest getClearDuplicateDataRequest() {
        DBRequest dbRequest = new DBRequest();
        String deleteSql = "DELETE FROM t_monitor_api_metadata WHERE fid NOT IN (SELECT b.bid FROM (SELECT min(fid) bid FROM t_monitor_api_metadata group BY fappid,fapiname)b)";
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, null));
        return dbRequest;
    }
}

