/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.metadata.api;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.dlock.DLock;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.api.ApiMetadataHistoricalDataClean;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.reporter.apicall.APIMetaData;

public class ApiMetadataManager {
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final String dLockPath = "/dlock/monitor/apiMetadataManager/db/save";
    private static boolean stop = false;
    private static List<Request> list = new ArrayList<Request>(256);
    private static Log log = LogFactory.getLog(ApiMetadataManager.class);
    private static Long lastTime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toSaveDB() {
        ArrayList<Request> copyList = new ArrayList<Request>(8);
        try {
            lock.readLock().lock();
            copyList.addAll(list);
            list.clear();
        }
        finally {
            lock.readLock().unlock();
        }
        DLock dLock = DLock.create((String)dLockPath);
        try {
            if (!dLock.tryLock()) {
                TimeUnit.SECONDS.sleep(5L);
                return;
            }
            ArrayList<Request> insertList = new ArrayList<Request>(copyList.size());
            int[] updateResultArr = MetadataFactory.getStatement().executeUpdateBatch(copyList);
            for (int i = 0; i < updateResultArr.length; ++i) {
                if (updateResultArr[i] != 0) continue;
                insertList.add((Request)copyList.get(i));
            }
            MetadataFactory.getStatement().executeInsertBatch(insertList);
        }
        catch (InterruptedException e) {
            log.warn("ApiMetadataManager.toSaveDB error:", (Throwable)e);
        }
        finally {
            dLock.unlock();
        }
    }

    public static void save(APIMetaData metaData) {
        DBRequest dbRequest = ApiMetadataManager.creatAPIMetaDataRequest(metaData);
        try {
            lock.writeLock().lock();
            list.add(dbRequest);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private static DBRequest creatAPIMetaDataRequest(APIMetaData metaData) {
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fid from t_monitor_api_metadata where fclustername = ? and fappid = ? and fapiname = ?";
        ArrayList queryList = new ArrayList(4);
        String appId = metaData.getAppId() == null ? " " : metaData.getAppId();
        Collections.addAll(queryList, Instance.getClusterName(), appId, metaData.getSignature());
        String insertSql = "insert into t_monitor_api_metadata values(?,?,?,?,?,?,?)";
        ArrayList insertList = new ArrayList(6);
        Collections.addAll(insertList, ID.genLongId(), Instance.getClusterName(), appId, metaData.getSignature(), metaData.getType(), LocalDateTime.now(), " ");
        String updateSql = "update t_monitor_api_metadata set ftype= ?,fupdatetime = ? where fclustername= ? and fappid= ? and fapiname = ?";
        ArrayList updateList = new ArrayList(5);
        Collections.addAll(updateList, metaData.getType(), LocalDateTime.now(), Instance.getClusterName(), appId, metaData.getSignature());
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
        return dbRequest;
    }

    static {
        ApiMetadataHistoricalDataClean.updateHystroyData();
        Thread t = new Thread(() -> {
            while (!stop) {
                try {
                    if (list.size() == 0) {
                        TimeUnit.SECONDS.sleep(30L);
                        continue;
                    }
                    if (list.size() >= 1000 || System.currentTimeMillis() - lastTime > 120000L) {
                        ApiMetadataManager.toSaveDB();
                        lastTime = System.currentTimeMillis();
                        continue;
                    }
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (Exception e) {
                    log.warn("ApiMetadataManager: run task of save apiMetadata ", (Throwable)e);
                }
            }
        }, "ApiMetadataManager-save");
        t.setDaemon(true);
        t.start();
    }
}

