/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.storage;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.govern.StorageType;
import kd.bos.government.logrule.LogRuleHistoricalDataClean;
import kd.bos.government.metadata.api.ApiMetadataHistoricalDataClean;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public enum HistoricalDataClearService {
    INSTANCE;

    private static final StorageType storageType;
    private static final Storage store;
    private static final Log logger;

    public void start() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "HistoricalDataClearService"));
        executorService.scheduleWithFixedDelay(() -> this.runTask(), 1L, 24L, TimeUnit.HOURS);
        logger.info("apm history data clear service start...");
    }

    private void runTask() {
        store.clearHistoryData(Integer.parseInt(System.getProperty("apm.gov.storage.days", "1")));
        ApiMetadataHistoricalDataClean.clear();
        LogRuleHistoricalDataClean.clear();
    }

    static {
        storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type"));
        store = StorageFactory.getStorage(storageType);
        logger = LogFactory.getLog(HistoricalDataClearService.class);
    }
}

