/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.impl.NoOutStorage;
import kd.bos.government.storage.impl.elasticsearch.ElasticsearchStorage;

public class StorageFactory {
    private static final Map<StorageType, Storage> storagePool = new ConcurrentHashMap<StorageType, Storage>(8);

    public static Storage getStorage(StorageType storageType) {
        return storagePool.computeIfAbsent(storageType, k -> {
            if (storageType == StorageType.DB) {
                return new NoOutStorage();
            }
            if (storageType == StorageType.ELASTICSEARCH) {
                return new ElasticsearchStorage();
            }
            return new NoOutStorage();
        });
    }
}

