/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.storage.impl.elasticsearch;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageRequest;
import kd.bos.government.storage.impl.elasticsearch.ElasticsearchClient;
import kd.bos.government.storage.impl.elasticsearch.ElasticsearchClientFactory;

public class ElasticsearchStorage
implements Storage {
    private static final ElasticsearchClient esClient = ElasticsearchClientFactory.getElasticsearchClient();
    private static final boolean IS_ASYNC = Boolean.parseBoolean(System.getProperty("apm.gov.invoke.report.storage.async", "true"));

    @Override
    public void execute(List<StorageRequest> storageRequests) {
        if (IS_ASYNC) {
            esClient.asyncExecute(storageRequests);
        } else {
            esClient.execute(storageRequests);
        }
    }

    @Override
    public void asyncExecute(List<StorageRequest> storageRequests) {
        esClient.asyncExecute(storageRequests);
    }

    @Override
    public List<Map<String, Object>> queryTopology(Date from, Date to, String instance) {
        return esClient.queryTopology(from, to, instance);
    }

    @Override
    public List<Map<String, Object>> queryServiceInstTopology(Date from, Date to, String instance) {
        return esClient.queryServiceInstTopology(from, to, instance);
    }

    @Override
    public void clearHistoryData(int days) {
        esClient.clearHistoryData(days);
    }

    @Override
    public Map<String, Map<String, Object>> apiCallStats(Date from, Date to, String apiName, String apiType) {
        return esClient.apiCallStats(from, to, apiName, apiType);
    }

    @Override
    public List<Map<String, Object>> apiCallDetail(Date from, Date to, String apiName) {
        return esClient.apiCallDetail(from, to, apiName);
    }

    @Override
    public List<Map<String, Object>> eventData(Date from, Date to, Map<String, String> params) {
        return esClient.eventData(from, to, params);
    }

    @Override
    public Map<String, Map<String, Object>> queryArmorLinkData(Map<String, Object> map) {
        return esClient.queryArmorLinkData(map);
    }

    @Override
    public Map<String, Object> traceList(Date from, Date to, Map<String, String> param) {
        return esClient.traceList(from, to, param);
    }

    @Override
    public JSONObject queryMetrics(Map<String, Object> params) {
        return esClient.queryMetrics(params);
    }

    @Override
    public JSONArray queryTenantMetrics(Map<String, Object> params) {
        return esClient.queryTenantMetrics(params);
    }

    @Override
    public JSONObject queryTopo(Date from, Date to, String source, String target, String minDuration) {
        return esClient.queryTopo(from, to, source, target, minDuration);
    }

    @Override
    public JSONObject queryTopoServiceInstances(Date from, Date to, String source, String target, String minDuration) {
        return esClient.queryTopoServiceInstances(from, to, source, target, minDuration);
    }

    @Override
    public JSONObject queryInvokeDetail(Date from, Date to, String source, String target, String orderType, int topLine, int usedTime, String rangeOrder) {
        return esClient.queryInvokeDetail(from, to, source, target, orderType, topLine, usedTime, rangeOrder);
    }

    @Override
    public JSONObject queryApiInvoker(Date from, Date to, String source, String target, String apiName) {
        return esClient.queryApiInvoker(from, to, source, target, apiName);
    }

    @Override
    public JSONObject queryComponentTopo(Date from, Date to, String source, String target, String type) {
        return esClient.queryComponentTopo(from, to, source, target, type);
    }

    @Override
    public JSONObject queryComponentInvoker(Date from, Date to, String source, String target, String type, String apiName) {
        return esClient.queryComponentInvoker(from, to, source, target, type, apiName);
    }
}

