/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.government.storage.impl.elasticsearch.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.bos.govern.SearcherCondition;
import kd.bos.govern.StorageExtensionSearcher;
import kd.bos.government.storage.impl.elasticsearch.ElasticsearchClient;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.storage.impl.elasticsearch.client.HighLevelAccessClient;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ExtensionHighLevelAccessClient
extends HighLevelAccessClient
implements StorageExtensionSearcher {
    private static Log log = LogFactory.getLog(ExtensionHighLevelAccessClient.class);

    public ExtensionHighLevelAccessClient(ElasticsearchConfig elasticsearchConfig) {
        super(elasticsearchConfig);
    }

    public void queryByScroll(SearcherCondition condition) {
        Date from = condition.getFrom();
        Date to = condition.getTo();
        String indexPre = condition.getIndexPre();
        String[] fields = condition.getFields();
        QueryBuilder where = condition.getWhere();
        String orderby = condition.getOrderby();
        int batch = condition.getBatch();
        int maxSize = condition.getMaxSize();
        Consumer consumer = condition.getConsumer();
        boolean isAllField = fields == null || fields.length == 1 && "*".equals(fields[0]);
        String[] indices = ElasticsearchClient.getIndices(from, to, indexPre);
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (batch > 5000 || batch < 100) {
            batch = 2000;
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)from.getTime()).lte((Object)to.getTime()));
        if (where != null) {
            boolQuery.must(where);
        }
        builder.query((QueryBuilder)boolQuery).size(batch);
        if (orderby != null && orderby.length() > 0) {
            String[] items;
            for (String item : items = orderby.split(",")) {
                String[] orderPair = item.split(":");
                if (orderPair.length == 2) {
                    builder.sort(orderPair[0], SortOrder.fromString((String)orderPair[1]));
                    continue;
                }
                if (orderPair.length != 1) continue;
                builder.sort(orderPair[0]);
            }
        }
        if (fields != null && !isAllField) {
            builder.fetchSource(fields, null);
        }
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)30L));
        SearchRequest req = new SearchRequest().indices(indices).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false)).scroll(scroll).source(builder);
        SearchResponse sResponse = null;
        try {
            sResponse = this.esClient.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("scrollRequest error", (Throwable)e);
        }
        if (sResponse == null || sResponse.getHits() == null) {
            log.warn("scrollRequest searchResponse or hits is null");
            return;
        }
        String scrollId = sResponse.getScrollId();
        SearchHit[] hits = sResponse.getHits().getHits();
        ArrayList result = new ArrayList(4);
        AtomicInteger fetchSize = new AtomicInteger(0);
        while (hits != null && hits.length > 0 && fetchSize.get() < maxSize) {
            TraceSpan span = Tracer.create((String)"queryByScroll.scrollPage2", (String)"scrollPage");
            Throwable throwable = null;
            try {
                for (SearchHit hit : hits) {
                    Map source = hit.getSourceAsMap();
                    HashMap<String, String> row = new HashMap<String, String>(4);
                    if (isAllField) {
                        source.forEach((k, v) -> {
                            if (v != null) {
                                row.put((String)k, v.toString());
                            }
                        });
                    } else {
                        for (String field : fields) {
                            Object v2 = source.get(field);
                            if (v2 == null) continue;
                            row.put(field, v2.toString());
                        }
                    }
                    result.add(row);
                    if (fetchSize.incrementAndGet() > maxSize) break;
                }
                consumer.accept(result);
                result.clear();
                SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
                scrollRequest.scroll(scroll);
                try {
                    sResponse = this.esClient.scroll(scrollRequest, RequestOptions.DEFAULT);
                }
                catch (IOException e) {
                    log.error("scrollRequest error", (Throwable)e);
                }
                if (sResponse == null || sResponse.getHits() == null) {
                    log.warn("scrollRequest searchResponse or hits is null");
                    return;
                }
                scrollId = sResponse.getScrollId();
                hits = sResponse.getHits().getHits();
            }
            catch (Throwable scrollRequest) {
                throwable = scrollRequest;
                throw scrollRequest;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                span.close();
            }
        }
        if (scrollId == null) {
            return;
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        ClearScrollResponse clearScrollResponse = null;
        try {
            clearScrollResponse = this.esClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error("clearScroll error", (Throwable)e);
        }
        if (clearScrollResponse == null) {
            log.error("scrollRequest clearScrollResponse is null");
            return;
        }
        boolean succeeded = clearScrollResponse.isSucceeded();
        log.info("clearScrollResponse:" + succeeded);
    }
}

