/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.appsplit;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.Instance;
import kd.bos.mservice.appsplit.loadbalance.AppLoadBalanceParam;
import kd.bos.mservice.appsplit.loadbalance.AppLoadBalanceType;
import kd.bos.mservice.appsplit.loadbalance.AppRandomLoadBalance;

public class AppSplitServiceManager {
    private static Map<String, List<String>> appInstanceMap = new ConcurrentHashMap<String, List<String>>(8);
    private static List<String> appNames = new ArrayList<String>(2);
    private static final SecureRandom random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAppSplitService(Map<String, String> appidConfigures) {
        ConcurrentHashMap<String, List<String>> appTempMap = new ConcurrentHashMap<String, List<String>>(8);
        ArrayList<String> appTempNames = new ArrayList<String>(2);
        Map<String, String> map = appidConfigures;
        synchronized (map) {
            for (Map.Entry<String, String> m : appidConfigures.entrySet()) {
                String[] appids;
                String appName = AppSplitServiceManager.getAppName(m.getKey());
                String value = m.getValue();
                if (value == null || value.length() <= 0) continue;
                for (String appid : appids = value.split(",")) {
                    if (appid.length() <= 0) continue;
                    appTempNames.add(appName);
                    AppSplitServiceManager.setAppNameByAppId(appTempMap, appid, appName);
                }
            }
        }
        appInstanceMap = appTempMap;
        appNames = appTempNames;
    }

    public static String getAnyAppName() {
        return appNames.get(random.nextInt(appNames.size()));
    }

    public static String getAppSplitService(String appId) {
        if (null != appId) {
            String balanceType = System.getProperty("mservice.appsplit.balance.type", "random");
            return AppSplitServiceManager.getAppSplitService(appId, new AppLoadBalanceParam(AppLoadBalanceType.type(balanceType)));
        }
        return Instance.getAppName();
    }

    public static String getAppSplitService(String appId, AppLoadBalanceParam param) {
        List<String> appNameList = appInstanceMap.get(appId);
        if (null != appId) {
            return null != appNameList && appNameList.size() != 0 ? AppSplitServiceManager.getByBalanceType(appNameList, param) : null;
        }
        return Instance.getAppName();
    }

    private static void setAppNameByAppId(Map<String, List<String>> appTempMap, String appId, String appName) {
        List<String> list = appTempMap.get(appId);
        if (null != list && list.size() > 0) {
            list.add(appName);
        } else {
            list = new ArrayList<String>(1);
            list.add(appName);
            appTempMap.put(appId, list);
        }
    }

    private static String getAppName(String instanceIdAndName) {
        String appName = instanceIdAndName.substring(instanceIdAndName.indexOf("(") + 1, instanceIdAndName.indexOf(")"));
        return appName;
    }

    private static String getByBalanceType(List<String> list, AppLoadBalanceParam param) {
        if (list.size() == 1) {
            return list.get(0);
        }
        switch (param.getLoadBalanceType()) {
            default: 
        }
        return new AppRandomLoadBalance().select(list, param);
    }
}

