/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.appsplit.service;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.zoowhisper.NodeChangeListener;
import kd.bos.framework.zoowhisper.NodeChangeListenerWithInit;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.instance.Instance;
import kd.bos.mservice.appsplit.AppSplitServiceManager;
import kd.bos.mservice.monitor.ServiceInfoManger;

public class ClusterAppidsService
implements Service {
    private boolean started = false;
    private Map<String, String> appidConfigures = new ConcurrentHashMap<String, String>(2);

    public String getName() {
        return "ClusterAppidsService";
    }

    public void start() {
        ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
        messageCenter.addWatch("configUrl", Instance.getClusterName() + "/runtime/clusterappids", (NodeChangeListener)new NodeChangeListenerWithInit(){

            public void init(Map<String, String> nodes) {
                ClusterAppidsService.this.appidConfigures.putAll(nodes);
                ClusterAppidsService.this.updateSystemProperties();
                AppSplitServiceManager.setAppSplitService(ClusterAppidsService.this.appidConfigures);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onChange(String key, String value) {
                Map map = ClusterAppidsService.this.appidConfigures;
                synchronized (map) {
                    if (value == null) {
                        ClusterAppidsService.this.appidConfigures.remove(key);
                    } else {
                        ClusterAppidsService.this.appidConfigures.put(key, value);
                    }
                }
                ClusterAppidsService.this.updateSystemProperties();
                AppSplitServiceManager.setAppSplitService(ClusterAppidsService.this.appidConfigures);
            }
        });
        messageCenter.setNode("configUrl", Instance.getClusterName() + "/runtime/clusterappids", Instance.getInstanceId() + "(" + Instance.getAppName() + ")", this.getAppIdsString());
        ServiceInfoManger.initServiceInfos();
        this.started = true;
    }

    private String getAppIdsString() {
        String[] appids = Instance.getAppIds();
        Set clouds = Instance.getDeployedClouds();
        StringBuilder appidsStr = new StringBuilder();
        clouds.forEach(cloud -> appidsStr.append("cloud--").append((String)cloud).append(","));
        if (appids != null) {
            for (String appid : appids) {
                if (Instance.getDeployedCloudByApp((String)appid) != null) continue;
                appidsStr.append(appid).append(",");
            }
        }
        if (appidsStr.toString().endsWith(",")) {
            appidsStr.deleteCharAt(appidsStr.lastIndexOf(","));
        }
        return appidsStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSystemProperties() {
        HashSet s = new HashSet();
        Map<String, String> map = this.appidConfigures;
        synchronized (map) {
            this.appidConfigures.forEach((k, v) -> {
                if (v != null) {
                    String[] appids;
                    for (String appid : appids = v.split(",")) {
                        if (appid.length() <= 0 || "#nullstring#".equals(appid)) continue;
                        s.add(appid);
                    }
                }
            });
        }
        if (s.isEmpty()) {
            System.clearProperty("registedAppIds");
        } else {
            System.setProperty("registedAppIds", s.stream().collect(Collectors.joining(",")));
        }
    }

    public void stop() {
    }

    public boolean isStarted() {
        return this.started;
    }
}

