/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.debug;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.framework.lifecycle.SysServiceLayerManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DebugUtil {
    private static final Log log = LogFactory.getLog(DebugUtil.class);
    public static final String debugAppId = "debug";
    public static final boolean dev_log_sysout = Boolean.getBoolean("dev.log.sysout");
    public static final Method getThreadDebugId;
    public static final Method getDebugThreadType;
    public static final Method runAtDebugMainThread;
    public static final Method runAtDebugCmdThread;
    public static final Class<? extends Enum> enumType;
    public static final Method setupThreadDebug;
    public static final Method clearThreadDebug;
    private static final String DISPATCH_INVOKER_INFO_PREFIX = "kd.bos.service.DispatchService.invoke(kd.bos.service.ServiceFactory, ";
    private static final int DISPATCH_INVOKER_INFO_PREFIX_LEN;

    public static String getDebugId() {
        try {
            RequestContext rc = RequestContext.get();
            if (rc != null) {
                return rc.getDebugInfo() == null ? null : rc.getDebugInfo().getDebugId();
            }
            return (String)getThreadDebugId.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isDebugMode() {
        return DebugUtil.getDebugId() != null;
    }

    public static boolean isCMDThread() {
        try {
            RequestContext rc = RequestContext.get();
            if (rc != null) {
                return rc.getDebugInfo() == null ? false : rc.getDebugInfo().getDebugThreadType().equals("cmd");
            }
            return String.valueOf(getDebugThreadType.invoke(null, new Object[0])).equals("cmd");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void debug(String msg) {
        log.info(msg);
    }

    public static Supplier<String> wrapInvokerInfoSupplier(Supplier<String> invokerInfo) {
        return () -> {
            String info = (String)invokerInfo.get();
            if (info.startsWith(DISPATCH_INVOKER_INFO_PREFIX)) {
                info = info.substring(DISPATCH_INVOKER_INFO_PREFIX_LEN, info.length() - 1);
            }
            return info;
        };
    }

    public static String argumentsInfo(Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        int max = 255;
        StringBuilder buf = new StringBuilder(255);
        for (Object arg : args) {
            buf.append(arg).append(",");
            if (buf.length() <= 255) continue;
            return buf.substring(0, 255) + "...[" + args.length + "]";
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    static {
        String classNameScriptExecutorFactory = "kd.bos.script.ScriptExecutorFactory";
        String classNameDebugManager = "kd.bos.script.debug.DebugManager";
        String classNameDebugThreadType = "kd.bos.script.debug.DebugThreadType";
        if (!SysServiceLayerManager.isNeedDebugModel()) {
            classNameScriptExecutorFactory = "kd.bos.mservice.debug.ScriptExecutorFactory";
            classNameDebugManager = "kd.bos.mservice.debug.DebugManager";
            classNameDebugThreadType = "kd.bos.mservice.debug.DebugThreadType";
        }
        try {
            Class<?> clsScriptExecutorFactory = Class.forName(classNameScriptExecutorFactory);
            getThreadDebugId = clsScriptExecutorFactory.getMethod("getThreadDebugId", new Class[0]);
            getDebugThreadType = clsScriptExecutorFactory.getMethod("getDebugThreadType", new Class[0]);
            clearThreadDebug = clsScriptExecutorFactory.getMethod("clearThreadDebug", String.class);
            Class<?> clsDebugManager = Class.forName(classNameDebugManager);
            runAtDebugMainThread = clsDebugManager.getMethod("runAtDebugMainThread", String.class, Callable.class, Supplier.class);
            runAtDebugCmdThread = clsDebugManager.getMethod("runAtDebugCmdThread", String.class, Callable.class, Supplier.class);
            enumType = Class.forName(classNameDebugThreadType);
            setupThreadDebug = clsScriptExecutorFactory.getMethod("setupThreadDebug", String.class, enumType);
        }
        catch (Error | Exception e) {
            log.error("DebugUtil init error", e);
            throw new RuntimeException(e);
        }
        DISPATCH_INVOKER_INFO_PREFIX_LEN = DISPATCH_INVOKER_INFO_PREFIX.length();
    }
}

