/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.debug.conf;

import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactoryBuilder;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.mservice.debug.conf.DebugAttachConf;

public class ClusterDebugAttachConf
implements DebugAttachConf {
    private static final String TYPE = "debug";
    private DistributeSessionlessCache cache = CacheFactoryBuilder.newBuilder().build().getDistributeSessionlessCache();

    @Override
    public void attach(String debugId, String url) {
        if (!Objects.equals(this.cache.get(TYPE, debugId), url)) {
            this.cache.put(TYPE, debugId, (Object)url);
        }
    }

    @Override
    public void detachByDebugId(String debugId) {
        this.cache.remove(TYPE, debugId);
    }

    @Override
    public void detachByRouteKey(String routeKey) {
        Map map = this.cache.getAll(TYPE);
        String key = null;
        for (Map.Entry debugId : map.entrySet()) {
            if (!routeKey.equals(debugId.getValue())) continue;
            key = (String)debugId.getKey();
            break;
        }
        if (key != null) {
            this.cache.remove(TYPE, key);
        }
    }

    @Override
    public String getRouteKey(String debugId) {
        return (String)this.cache.get(TYPE, debugId);
    }
}

