/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.lang;

import com.sun.net.httpserver.HttpExchange;
import java.util.Locale;
import kd.bos.mservice.monitor.lang.LangUtil;
import kd.bos.thread.ThreadTruck;

public class LangContext {
    public static final String KEY_LANGUAGE_COOKIE_NAME = "monitor_language";
    private Locale locale;

    public static Locale getLocaleFromThreadTruck() {
        LangContext langContext = (LangContext)ThreadTruck.get((Object)KEY_LANGUAGE_COOKIE_NAME);
        Locale locale = Locale.getDefault();
        if (langContext != null) {
            locale = langContext.getLocale();
        }
        return locale;
    }

    public static void setLangContext(HttpExchange exchange) {
        ThreadTruck.put((Object)KEY_LANGUAGE_COOKIE_NAME, (Object)new LangContext(exchange));
    }

    public LangContext(Locale locale) {
        this.locale = locale;
    }

    public LangContext(String lang) {
        this.initLocale(lang);
    }

    public LangContext(HttpExchange exchange) {
        this.locale = LangUtil.tryGetLocal(exchange);
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
    }

    private void initLocale(String lang) {
        String[] l = lang.split("_");
        this.locale = l.length == 1 ? new Locale(l[0]) : (l.length == 2 ? new Locale(l[0], l[1]) : (l.length == 3 ? new Locale(l[0], l[1], l[2]) : Locale.getDefault()));
    }

    public Locale getLocale() {
        return this.locale;
    }
}

