/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.lang;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import sun.misc.InvalidJarIndexException;

public final class LangResBundle {
    private static final Log log = LogFactory.getLog(LangResBundle.class);
    private static final LangResBundle instance = new LangResBundle();
    private final ConcurrentHashMap<String, ResourceBundle> cache = new ConcurrentHashMap();
    private final List<Locale> allowLocale = Collections.unmodifiableList(Lists.newArrayList((Object[])new Locale[]{Locale.ROOT, Locale.ENGLISH, Locale.US, Locale.SIMPLIFIED_CHINESE, Locale.CHINESE}));

    public static LangResBundle getInstance() {
        return instance;
    }

    private LangResBundle() {
    }

    public String get(String baseName, Locale locale, String key, String def, Object ... args) {
        Objects.requireNonNull(baseName, "Parameter baseName can not be null");
        Objects.requireNonNull(locale, "Parameter locale can not be null");
        Objects.requireNonNull(key, "Parameter key can not be null");
        String result = def;
        if (this.allowLocale.contains(locale)) {
            String localString = locale.toString();
            if (locale.equals(Locale.ROOT)) {
                localString = "root";
            }
            String cacheKey = baseName + '@' + localString;
            ResourceBundle bundle = null;
            try {
                bundle = this.cache.computeIfAbsent(cacheKey, k -> this.getResourceBundle(baseName, locale));
                result = bundle.getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (args == null || args.length == 0) {
            return result;
        }
        try {
            return MessageFormat.format(result, args);
        }
        catch (IllegalArgumentException e) {
            return result;
        }
    }

    private ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return ResourceBundle.getBundle(baseName, locale, new ResourceBundle.Control(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, "properties");
                try (InputStream stream = loader.getResourceAsStream(resourceName);){
                    if (stream == null) {
                        ResourceBundle resourceBundle = null;
                        return resourceBundle;
                    }
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    return propertyResourceBundle;
                }
                catch (IOException ioException) {
                    log.debug("Cause an IOException when get resource bundle, detail message is: " + ioException.getMessage(), (Object)ioException);
                    throw ioException;
                }
                catch (InvalidJarIndexException jarIndexException) {
                    log.debug("Cause an InvalidJarIndexException when get resource bundle, detail message is: " + jarIndexException.getMessage(), (Object)jarIndexException);
                    throw jarIndexException;
                }
            }

            @Override
            public Locale getFallbackLocale(String baseName, Locale locale) {
                if (baseName == null) {
                    throw new NullPointerException();
                }
                if (locale.equals(Locale.ROOT)) {
                    return null;
                }
                return Locale.ROOT;
            }
        });
    }
}

