/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.lang;

import java.io.InputStream;
import java.util.Locale;
import kd.bos.mservice.monitor.lang.LangContext;
import kd.bos.util.Pair;

public final class LangResourceStreamFactory {
    public static InputStream getResourceStream(ClassLoader classLoader, String fileName) {
        Locale locale = LangContext.getLocaleFromThreadTruck();
        String langFileName = LangResourceStreamFactory.toBundleName(fileName, locale);
        InputStream stream = LangResourceStreamFactory.tryGetInputStream(langFileName, classLoader);
        if (stream == null) {
            stream = LangResourceStreamFactory.tryGetInputStream(fileName, classLoader);
        }
        return stream;
    }

    static InputStream tryGetInputStream(String fullName, ClassLoader classLoader) {
        return classLoader.getResourceAsStream(fullName);
    }

    static String toBundleName(String baseName, Locale locale) {
        if (locale == Locale.ROOT) {
            return baseName;
        }
        String language = locale.getLanguage();
        String script = locale.getScript();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if ("".equals(language) && "".equals(country) && "".equals(variant)) {
            return baseName;
        }
        Pair<String, String> names = LangResourceStreamFactory.separateFileName(baseName);
        StringBuilder sb = new StringBuilder((String)names.getKey());
        sb.append('_');
        if (!"".equals(script)) {
            if (!"".equals(variant)) {
                sb.append(language).append('_').append(script).append('_').append(country).append('_').append(variant);
            } else if (!"".equals(country)) {
                sb.append(language).append('_').append(script).append('_').append(country);
            } else {
                sb.append(language).append('_').append(script);
            }
        } else if (!"".equals(variant)) {
            sb.append(language).append('_').append(country).append('_').append(variant);
        } else if (!"".equals(country)) {
            sb.append(language).append('_').append(country);
        } else {
            sb.append(language);
        }
        sb.append((String)names.getValue());
        return sb.toString();
    }

    static Pair<String, String> separateFileName(String fileName) {
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("file name is null or empty.");
        }
        int index = fileName.lastIndexOf(46);
        if (index <= 0) {
            return new Pair((Object)fileName, null);
        }
        return new Pair((Object)fileName.substring(0, index), (Object)fileName.substring(index));
    }
}

