/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.lang;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LangUtil {
    private LangUtil() {
    }

    public static Locale tryGetLocal(HttpExchange exchange) {
        Locale locale = LangUtil.getFromQuery(exchange);
        if (locale == null) {
            locale = LangUtil.getFromCookie(exchange);
        }
        return locale;
    }

    private static Locale getFromQuery(HttpExchange exchange) {
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getQuery());
        String lang = params.get("monitor_language");
        return LangUtil.createLocale(lang);
    }

    private static Locale getFromCookie(HttpExchange httpExchange) {
        Headers requestHeaders = httpExchange.getRequestHeaders();
        String cookie = requestHeaders.getFirst("Cookie");
        if (cookie != null) {
            String[] cookiePairs;
            for (String cookiePair : cookiePairs = cookie.split("; ")) {
                String[] parts = cookiePair.split("=");
                if (parts.length != 2) continue;
                String name = parts[0];
                String value = parts[1];
                if (!name.equals("monitor_language")) continue;
                return LangUtil.createLocale(value);
            }
        }
        return null;
    }

    private static Locale createLocale(String lang) {
        if (lang == null || lang.trim().isEmpty()) {
            return null;
        }
        String[] l = lang.split("_");
        if (l.length == 1) {
            return new Locale(l[0]);
        }
        if (l.length == 2) {
            return new Locale(l[0], l[1]);
        }
        if (l.length == 3) {
            return new Locale(l[0], l[1], l[2]);
        }
        return null;
    }

    private static class EyeUriQuery {
        private HashMap<String, String> map = new HashMap(2);
        private String query;

        public EyeUriQuery(String query) {
            if (query == null) {
                return;
            }
            this.query = query;
            this.init(query);
        }

        private void init(String query) {
            String[] parts;
            for (String part : parts = query.split("&")) {
                String[] kv = part.split("=");
                if (kv.length != 2 || kv[0] == null || kv[1] == null) continue;
                try {
                    String key = URLDecoder.decode(kv[0], "UTF-8");
                    String value = URLDecoder.decode(kv[1], "UTF-8");
                    this.map.put(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }

        public Map<String, String> toMap() {
            return this.map;
        }

        public String toString() {
            return this.query;
        }

        public static Map<String, String> toMap(String query) {
            return new EyeUriQuery(query).toMap();
        }
    }
}

