/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;

public class CacheConfigKeys {
    public static final String XCACHE_SESSIONLESS = "xcache.client.serversForCache";
    public static final String XCACHE_WHITE_LIST = "xcache.client.whitelist";
    public static final String XCACHE_ClIENT_ENABLE = "xcache.client.enable";
    public static boolean isXCacheAutoSwitchEnable = Boolean.getBoolean("xcache.autoSwitch.enable");
    public static final char XCACHE_WHITE_LIST_DELIMITER = ';';

    public static String getSessionableConfigKey() {
        return "redis.serversForSession";
    }

    public static String getSessionlessConfigKey(String region) {
        String key = "redis.serversForCache";
        if (region != null) {
            key = key + "." + region;
        }
        return key;
    }

    public static String getXCacheSessionlessConfigKey(String region) {
        if (region == null || region.trim().isEmpty()) {
            return XCACHE_SESSIONLESS;
        }
        return String.format("%s.%s", XCACHE_SESSIONLESS, region);
    }

    public static String getXCacheUrl(String region) {
        String configKey = CacheConfigKeys.getXCacheSessionlessConfigKey(region);
        String result = System.getProperty(configKey);
        if (result == null || result.trim().isEmpty()) {
            configKey = CacheConfigKeys.getXCacheSessionlessConfigKey(null);
            result = System.getProperty(configKey);
        }
        return result;
    }

    public static boolean isXCacheClientEnabled() {
        return Boolean.getBoolean(XCACHE_ClIENT_ENABLE);
    }

    public static boolean hasXCacheConfiguration(String region) {
        String url = System.getProperty(CacheConfigKeys.getXCacheSessionlessConfigKey(region));
        return StringUtils.isNotEmpty((String)url);
    }

    public static String[] getXCacheWhiteList() {
        String whileList = System.getProperty(XCACHE_WHITE_LIST);
        if (StringUtils.isEmpty((String)whileList)) {
            return new String[0];
        }
        return (String[])CacheConfigKeys.splitString(whileList, ';').stream().map(String::trim).filter(StringUtils::isNotEmpty).toArray(String[]::new);
    }

    static List<String> splitString(String input, char delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (escape) {
                sb.append(c);
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == delimiter) {
                result.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        result.add(sb.toString());
        return result;
    }

    public static boolean isXCacheAutoSwitch() {
        return isXCacheAutoSwitchEnable;
    }
}

