/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.SessionlessCache;
import kd.sdk.annotation.SdkPublic;
import redis.clients.jedis.util.SafeEncoder;

@SdkPublic
public interface DistributeSessionlessCache
extends SessionlessCache<String> {
    public int addList(String var1, String[] var2);

    default public int addList(String key, String[] values, int timeoutSeconds) {
        return this.addList(key, values, timeoutSeconds, TimeUnit.SECONDS);
    }

    public int addList(String var1, String[] var2, int var3, TimeUnit var4);

    default public int resetList(String key, String[] values, int timeoutSeconds) {
        return this.resetList(key, values, timeoutSeconds, TimeUnit.SECONDS);
    }

    public int resetList(String var1, String[] var2, int var3, TimeUnit var4);

    public int insertList(String var1, int var2, String[] var3);

    public void setListObject(String var1, int var2, String var3);

    public String[] getList(String var1);

    public String[] getList(String var1, int var2, int var3);

    public String getListObject(String var1, int var2);

    public void removeListObject(String var1, int var2);

    public void removeListObjects(String var1, int var2, int var3);

    public int getListLength(String var1);

    public int addToSet(String var1, String[] var2);

    default public int addToSet(String key, String[] values, int timeoutSeconds) {
        return this.addToSet(key, values, timeoutSeconds, TimeUnit.SECONDS);
    }

    public int addToSet(String var1, String[] var2, int var3, TimeUnit var4);

    public void removeSetValues(String var1, String[] var2);

    public String[] getSetValues(String var1);

    public int getSetLength(String var1);

    @Override
    public void put(String var1, byte[] var2);

    @Override
    public void put(String var1, byte[] var2, int var3);

    public byte[] getByteValue(String var1);

    public void hset(String var1, byte[] var2, byte[] var3);

    public void hset(String var1, byte[] var2, byte[] var3, int var4);

    public void hmset(String var1, Map<byte[], byte[]> var2);

    public void hmset(String var1, Map<byte[], byte[]> var2, int var3);

    public byte[] hget(String var1, byte[] var2);

    public Map<byte[], byte[]> hgetAll(String var1);

    public List<byte[]> hmget(String var1, byte[] ... var2);

    @Deprecated
    public Object eval(String var1, String var2, List<String> var3);

    default public boolean isAvailable() {
        return true;
    }

    default public void put(byte[] key, byte[] value, int timeout) {
        this.put(SafeEncoder.encode((byte[])key), value, timeout);
    }

    default public byte[] get(byte[] key) {
        return this.getByteValue(SafeEncoder.encode((byte[])key));
    }

    default public void remove(byte[] key) {
        this.remove(SafeEncoder.encode((byte[])key));
    }
}

