/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.LocalCacheMonitorInfo;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ehcache.EhcacheSessionlessCache;
import kd.bos.cache.ehcache.EhcacheSessionlessCacheWrapper;
import kd.bos.cache.ehcache.LocalSessionCacheRegionManger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LocalCacheMonitor {
    private static final Log log = LogFactory.getLog(LocalCacheMonitor.class);
    private static Map<String, LocalMemoryCache> localSessionlessCaches = null;

    protected static void registryCacheMap(Map<String, LocalMemoryCache> caches) {
        localSessionlessCaches = caches;
    }

    public static List<LocalCacheMonitorInfo> getCaches(String cacheFilterkey) {
        ArrayList<LocalCacheMonitorInfo> monitorInfo = new ArrayList<LocalCacheMonitorInfo>();
        boolean isFilter = cacheFilterkey != null && cacheFilterkey.trim().length() > 0;
        localSessionlessCaches.forEach((region, v) -> {
            boolean isRegionMatch = isFilter ? region.toLowerCase().contains(cacheFilterkey.toLowerCase()) : true;
            LocalSessionCacheRegionManger cache = (LocalSessionCacheRegionManger)v;
            Map<String, EhcacheSessionlessCacheWrapper> caches = cache.getCaches();
            caches.forEach((type, cacheWraper) -> {
                boolean isTypeMatch;
                boolean bl = isTypeMatch = isFilter ? type.toLowerCase().contains(cacheFilterkey.toLowerCase()) : true;
                if (isRegionMatch || isTypeMatch) {
                    LocalCacheMonitorInfo cmonitor = new LocalCacheMonitorInfo();
                    monitorInfo.add(cmonitor);
                    cmonitor.setRegion((String)region);
                    cmonitor.setType(type.substring(region.length() + 1));
                    cacheWraper.setStatics(cmonitor);
                }
            });
        });
        return monitorInfo;
    }

    public static void clearCache(String clearRegion, String clearType) {
        if (clearRegion == null || clearType == null) {
            return;
        }
        LocalSessionCacheRegionManger cache = (LocalSessionCacheRegionManger)localSessionlessCaches.get(clearRegion);
        if (cache == null) {
            return;
        }
        EhcacheSessionlessCacheWrapper cacheWraper = cache.getCaches().get(clearRegion + '-' + clearType);
        if (cacheWraper == null) {
            return;
        }
        cacheWraper.clear();
    }

    public static void clearAllLocalCache() {
        Set<Map.Entry<String, LocalMemoryCache>> entries = localSessionlessCaches.entrySet();
        for (Map.Entry<String, LocalMemoryCache> next : entries) {
            EhcacheSessionlessCache ehcacheSessionlessCache = (EhcacheSessionlessCache)next.getValue();
            Map<String, EhcacheSessionlessCacheWrapper> caches = ehcacheSessionlessCache.getCaches();
            Set<Map.Entry<String, EhcacheSessionlessCacheWrapper>> entrySet = caches.entrySet();
            for (Map.Entry<String, EhcacheSessionlessCacheWrapper> wrapperEntry : entrySet) {
                EhcacheSessionlessCacheWrapper sessionlessCacheWrapper = wrapperEntry.getValue();
                try {
                    sessionlessCacheWrapper.clear();
                }
                catch (Exception e) {
                    log.error("clear localCache error,key: " + wrapperEntry.getKey(), (Throwable)e);
                }
            }
        }
    }
}

