/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import kd.bos.cache.BatchUpdateDBCallback;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.UpdateDBCallback;
import kd.bos.cache.ehcache.EhcacheMemoryCacheClusterNotify;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class ModifyCachedValue<P> {
    private static CacheFactory factory = CacheFactory.getCommonCacheFactory();

    public void updateDBAndCache(UpdateDBCallback<P> callback, String region, String type, String key, P v) {
        callback.call(v);
        LocalMemoryCache localcache = factory.$getLocalMemoryCache(region, type);
        if (localcache != null) {
            localcache.remove(key);
            localcache.put(key, v);
        } else {
            EhcacheMemoryCacheClusterNotify.notifySync("remove", region, type, key);
        }
    }

    public void batchUpdateDBAndCache(BatchUpdateDBCallback<P> callback, String region, String type, String[] key, P[] v) {
        if (key == null || v == null || key.length != v.length) {
            throw new KDException(BosErrorCode.parse, new Object[]{"wrong params of batchUpdateDBAndCache: key is null or value is null or the length of key and value is not the same ."});
        }
        callback.call(v);
        LocalMemoryCache localcache = factory.$getLocalMemoryCache(region, type);
        if (localcache != null) {
            localcache.remove(key);
            for (int i = 0; i < key.length; ++i) {
                localcache.put(key[i], v[i]);
            }
        } else {
            EhcacheMemoryCacheClusterNotify.notifySync("remove", region, type, key);
        }
    }
}

