/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import java.util.Locale;
import kd.bos.util.StringUtils;

public enum TempFileCacheType {
    DISK("disk", "kd.bos.cache.tempfile.DiskTempFileCache"),
    REDIS("redis", "kd.bos.cache.tempfile.SplitRedisTempFileCache"),
    FILE_SERVER("fileserver", "kd.bos.cache.tempfile.FileServerTempFileCache");

    private final String name;
    private final String clazz;

    private TempFileCacheType(String name, String clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public static TempFileCacheType of(String name) {
        switch (name = StringUtils.isEmpty((String)name) ? "fileserver" : name.toLowerCase(Locale.ENGLISH)) {
            case "disk": {
                return DISK;
            }
            case "redis": 
            case "splitredis": {
                return REDIS;
            }
            case "fileserver": {
                return FILE_SERVER;
            }
        }
        throw new IllegalArgumentException("Illegal TempFileCacheType config: " + name + ". Check value of config [tempfile.cachetype].");
    }
}

